"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEngineConfigurationTypeName = exports.riskEngineConfigurationTypeMappings = exports.riskEngineConfigurationType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEngineConfigurationTypeName = 'risk-engine-configuration';
exports.riskEngineConfigurationTypeName = riskEngineConfigurationTypeName;
const riskEngineConfigurationTypeMappings = {
  dynamic: false,
  properties: {
    dataViewId: {
      type: 'keyword'
    },
    enabled: {
      type: 'boolean'
    },
    filter: {
      dynamic: false,
      properties: {}
    },
    identifierType: {
      type: 'keyword'
    },
    interval: {
      type: 'keyword'
    },
    pageSize: {
      type: 'integer'
    },
    range: {
      properties: {
        start: {
          type: 'keyword'
        },
        end: {
          type: 'keyword'
        }
      }
    }
  }
};
exports.riskEngineConfigurationTypeMappings = riskEngineConfigurationTypeMappings;
const riskEngineConfigurationType = {
  name: riskEngineConfigurationTypeName,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: riskEngineConfigurationTypeMappings
};
exports.riskEngineConfigurationType = riskEngineConfigurationType;