"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityUpsertRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../check_and_init_asset_criticality_resources");
var _route_validation = require("../../../../utils/build_validation/route_validation");
var _asset_criticality = require("../../../../../common/api/entity_analytics/asset_criticality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityUpsertRoute = (router, logger) => {
  router.versioned.post({
    access: 'internal',
    path: _constants.ASSET_CRITICALITY_URL,
    options: {
      tags: ['access:securitySolution', `access:${_constants.APP_ID}-entity-analytics`]
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithZod)(_asset_criticality.CreateAssetCriticalityRecord)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const securitySolution = await context.securitySolution;
      const assetCriticalityClient = securitySolution.getAssetCriticalityDataClient();
      const assetCriticalityRecord = {
        idField: request.body.id_field,
        idValue: request.body.id_value,
        criticalityLevel: request.body.criticality_level
      };
      const result = await assetCriticalityClient.upsert(assetCriticalityRecord);
      return response.ok({
        body: result
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.assetCriticalityUpsertRoute = assetCriticalityUpsertRoute;