"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildThreatEnrichment = void 0;
var _build_threat_mapping_filter = require("./build_threat_mapping_filter");
var _get_signals_map_from_threat_index = require("./get_signals_map_from_threat_index");
var _threat_enrichment_factory = require("./threat_enrichment_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// we do want to make extra requests to the threat index to get enrichments from all threats
// previously we were enriched alerts only from `currentThreatList` but not all threats
const buildThreatEnrichment = ({
  ruleExecutionLogger,
  services,
  threatFilters,
  threatIndex,
  threatIndicatorPath,
  threatLanguage,
  threatQuery,
  pitId,
  reassignPitId,
  listClient,
  exceptionFilter,
  threatMapping,
  runtimeMappings,
  threatIndexFields
}) => {
  return async signals => {
    const threatFiltersFromEvents = (0, _build_threat_mapping_filter.buildThreatMappingFilter)({
      threatMapping,
      threatList: signals,
      entryKey: 'field',
      allowedFieldsForTermsQuery: {
        source: {},
        threat: {}
      }
    });
    const threatSearchParams = {
      esClient: services.scopedClusterClient.asCurrentUser,
      threatFilters: [...threatFilters, threatFiltersFromEvents],
      query: threatQuery,
      language: threatLanguage,
      index: threatIndex,
      ruleExecutionLogger,
      threatListConfig: {
        _source: [`${threatIndicatorPath}.*`, 'threat.feed.*'],
        fields: undefined
      },
      pitId,
      reassignPitId,
      runtimeMappings,
      listClient,
      exceptionFilter,
      indexFields: threatIndexFields
    };
    const signalsQueryMap = await (0, _get_signals_map_from_threat_index.getSignalsQueryMapFromThreatIndex)({
      threatSearchParams,
      eventsCount: signals.length,
      termsQueryAllowed: false
    });
    const enrichment = (0, _threat_enrichment_factory.threatEnrichmentFactory)({
      signalsQueryMap,
      threatIndicatorPath,
      threatFilters,
      threatSearchParams
    });
    return enrichment(signals);
  };
};
exports.buildThreatEnrichment = buildThreatEnrichment;