"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidDateType = void 0;
var _moment = _interopRequireWildcard(require("moment"));
var _is_valid_numeric_type = require("./is_valid_numeric_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// ECS mapping date format is default optional strict-date-time and epoch ms time: "strict_date_optional_time||epoch_millis"
// https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-date-format.html#strict-date-time
const additionalFormats = ['yyyy-MM-DDT' // is valid for ES but not for moment's ISO_8601
];

/**
 * validates ES date type
 */
const isValidDateType = date => {
  // any number or string that can be parsed as valid number is a valid date for ES
  if ((0, _is_valid_numeric_type.isValidNumericType)(date)) {
    return true;
  }
  if (typeof date !== 'string') {
    return false;
  }
  return (0, _moment.default)(date, [_moment.ISO_8601, ...additionalFormats], true).isValid();
};
exports.isValidDateType = isValidDateType;