"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findRules = void 0;
var _enrich_filter_with_rule_type_mappings = require("./enrich_filter_with_rule_type_mappings");
var _transform_sort_field = require("./transform_sort_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findRules = ({
  rulesClient,
  perPage,
  page,
  fields,
  filter,
  sortField,
  sortOrder,
  hasReference
}) => {
  return rulesClient.find({
    options: {
      fields,
      page,
      perPage,
      filter: (0, _enrich_filter_with_rule_type_mappings.enrichFilterWithRuleTypeMapping)(filter),
      sortOrder,
      sortField: (0, _transform_sort_field.transformSortField)(sortField),
      hasReference
    }
  });
};
exports.findRules = findRules;