"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportAll = void 0;
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _get_existing_prepackaged_rules = require("../search/get_existing_prepackaged_rules");
var _get_export_details_ndjson = require("./get_export_details_ndjson");
var _utils = require("../../utils/utils");
var _get_export_rule_exceptions = require("./get_export_rule_exceptions");
var _get_export_rule_action_connectors = require("./get_export_rule_action_connectors");
var _transform_rule_to_exportable_format = require("./transform_rule_to_exportable_format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExportAll = async (rulesClient, exceptionsClient, actionsExporter, request, actionsClient) => {
  const ruleAlertTypes = await (0, _get_existing_prepackaged_rules.getNonPackagedRules)({
    rulesClient
  });
  const rules = (0, _utils.transformAlertsToRules)(ruleAlertTypes);
  const exportRules = rules.map(r => (0, _transform_rule_to_exportable_format.transformRuleToExportableFormat)(r));

  // Gather exceptions
  const exceptions = rules.flatMap(rule => {
    var _rule$exceptions_list;
    return (_rule$exceptions_list = rule.exceptions_list) !== null && _rule$exceptions_list !== void 0 ? _rule$exceptions_list : [];
  });
  const {
    exportData: exceptionLists,
    exportDetails: exceptionDetails
  } = await (0, _get_export_rule_exceptions.getRuleExceptionsForExport)(exceptions, exceptionsClient);

  // Retrieve Action-Connectors
  const {
    actionConnectors,
    actionConnectorDetails
  } = await (0, _get_export_rule_action_connectors.getRuleActionConnectorsForExport)(rules, actionsExporter, request, actionsClient);
  const rulesNdjson = (0, _securitysolutionUtils.transformDataToNdjson)(exportRules);
  const exportDetails = (0, _get_export_details_ndjson.getExportDetailsNdjson)(rules, [], exceptionDetails, actionConnectorDetails);
  return {
    rulesNdjson,
    exportDetails,
    exceptionLists,
    actionConnectors
  };
};
exports.getExportAll = getExportAll;