"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleManagementFilters = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _utils = require("../../../../routes/utils");
var _find_rules = require("../../../logic/search/find_rules");
var _read_tags = require("../../tags/read_tags/read_tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIND_RULES_COUNT_PARAMS = {
  perPage: 0,
  page: 1,
  sortField: undefined,
  sortOrder: undefined,
  fields: undefined
};
async function fetchRulesCount(rulesClient) {
  const [prebuiltRules, customRules] = await Promise.all([(0, _find_rules.findRules)({
    ...DEFAULT_FIND_RULES_COUNT_PARAMS,
    rulesClient,
    filter: 'alert.attributes.params.immutable: true'
  }), (0, _find_rules.findRules)({
    ...DEFAULT_FIND_RULES_COUNT_PARAMS,
    rulesClient,
    filter: 'alert.attributes.params.immutable: false'
  })]);
  return {
    prebuilt: prebuiltRules.total,
    custom: customRules.total
  };
}
const getRuleManagementFilters = router => {
  router.versioned.get({
    access: 'internal',
    path: _rule_management.RULE_MANAGEMENT_FILTERS_URL,
    options: {
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const ctx = await context.resolve(['alerting']);
    const rulesClient = ctx.alerting.getRulesClient();
    try {
      const [{
        prebuilt: prebuiltRulesCount,
        custom: customRulesCount
      }, tags] = await Promise.all([fetchRulesCount(rulesClient), (0, _read_tags.readTags)({
        rulesClient
      })]);
      const responseBody = {
        rules_summary: {
          custom_count: customRulesCount,
          prebuilt_installed_count: prebuiltRulesCount
        },
        aggregated_fields: {
          tags
        }
      };
      const [validatedBody, validationError] = (0, _securitysolutionIoTsUtils.validate)(responseBody, _rule_management.GetRuleManagementFiltersResponse);
      if (validationError != null) {
        return siemResponse.error({
          statusCode: 500,
          body: validationError
        });
      } else {
        return response.ok({
          body: validatedBody
        });
      }
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getRuleManagementFilters = getRuleManagementFilters;