"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleDiffAlgorithm = void 0;
var _utility_types = require("../../../../../../../../common/utility_types");
var _prebuilt_rules = require("../../../../../../../../common/api/detection_engine/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const simpleDiffAlgorithm = versions => {
  const {
    base_version: baseVersion,
    current_version: currentVersion,
    target_version: targetVersion
  } = versions;
  const diffOutcome = (0, _prebuilt_rules.determineDiffOutcome)(baseVersion, currentVersion, targetVersion);
  const valueCanUpdate = (0, _prebuilt_rules.determineIfValueCanUpdate)(diffOutcome);
  const {
    mergeOutcome,
    mergedVersion
  } = mergeVersions({
    currentVersion,
    targetVersion,
    diffOutcome
  });
  return {
    base_version: baseVersion,
    current_version: currentVersion,
    target_version: targetVersion,
    merged_version: mergedVersion,
    diff_outcome: diffOutcome,
    merge_outcome: mergeOutcome,
    has_update: valueCanUpdate,
    has_conflict: mergeOutcome === _prebuilt_rules.ThreeWayMergeOutcome.Conflict
  };
};
exports.simpleDiffAlgorithm = simpleDiffAlgorithm;
const mergeVersions = ({
  currentVersion,
  targetVersion,
  diffOutcome
}) => {
  switch (diffOutcome) {
    case _prebuilt_rules.ThreeWayDiffOutcome.StockValueNoUpdate:
    case _prebuilt_rules.ThreeWayDiffOutcome.CustomizedValueNoUpdate:
    case _prebuilt_rules.ThreeWayDiffOutcome.CustomizedValueSameUpdate:
      {
        return {
          mergeOutcome: _prebuilt_rules.ThreeWayMergeOutcome.Current,
          mergedVersion: currentVersion
        };
      }
    case _prebuilt_rules.ThreeWayDiffOutcome.StockValueCanUpdate:
      {
        return {
          mergeOutcome: _prebuilt_rules.ThreeWayMergeOutcome.Target,
          mergedVersion: targetVersion
        };
      }
    case _prebuilt_rules.ThreeWayDiffOutcome.CustomizedValueCanUpdate:
      {
        return {
          mergeOutcome: _prebuilt_rules.ThreeWayMergeOutcome.Conflict,
          mergedVersion: targetVersion
        };
      }
    default:
      return (0, _utility_types.assertUnreachable)(diffOutcome);
  }
};