"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppFeaturesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _app_features = require("@kbn/security-solution-features/app_features");
var _app_features2 = require("./app_features");
var _security_saved_objects = require("./security_saved_objects");
var _cases_privileges = require("./cases_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppFeaturesService {
  constructor(logger, experimentalFeatures) {
    (0, _defineProperty2.default)(this, "securityAppFeatures", void 0);
    (0, _defineProperty2.default)(this, "casesAppFeatures", void 0);
    (0, _defineProperty2.default)(this, "securityAssistantAppFeatures", void 0);
    (0, _defineProperty2.default)(this, "appFeatures", void 0);
    this.logger = logger;
    this.experimentalFeatures = experimentalFeatures;
    const securityFeature = (0, _app_features.getSecurityFeature)({
      savedObjects: _security_saved_objects.securityDefaultSavedObjects,
      experimentalFeatures: this.experimentalFeatures
    });
    this.securityAppFeatures = new _app_features2.AppFeatures(this.logger, securityFeature.subFeaturesMap, securityFeature.baseKibanaFeature, securityFeature.baseKibanaSubFeatureIds);
    const casesFeature = (0, _app_features.getCasesFeature)({
      uiCapabilities: _cases_privileges.casesUiCapabilities,
      apiTags: _cases_privileges.casesApiTags,
      savedObjects: {
        files: _saved_objects.hiddenTypes
      }
    });
    this.casesAppFeatures = new _app_features2.AppFeatures(this.logger, casesFeature.subFeaturesMap, casesFeature.baseKibanaFeature, casesFeature.baseKibanaSubFeatureIds);
    const assistantFeature = (0, _app_features.getAssistantFeature)();
    this.securityAssistantAppFeatures = new _app_features2.AppFeatures(this.logger, assistantFeature.subFeaturesMap, assistantFeature.baseKibanaFeature, assistantFeature.baseKibanaSubFeatureIds);
  }
  init(featuresSetup) {
    this.securityAppFeatures.init(featuresSetup);
    this.casesAppFeatures.init(featuresSetup);
    this.securityAssistantAppFeatures.init(featuresSetup);
  }
  setAppFeaturesConfigurator(configurator) {
    const securityAppFeaturesConfig = configurator.security();
    this.securityAppFeatures.setConfig(securityAppFeaturesConfig);
    const casesAppFeaturesConfig = configurator.cases();
    this.casesAppFeatures.setConfig(casesAppFeaturesConfig);
    const securityAssistantAppFeaturesConfig = configurator.securityAssistant();
    this.securityAssistantAppFeatures.setConfig(securityAssistantAppFeaturesConfig);
    this.appFeatures = new Set(Object.freeze([...securityAppFeaturesConfig.keys(), ...casesAppFeaturesConfig.keys(), ...securityAssistantAppFeaturesConfig.keys()]));
  }
  isEnabled(appFeatureKey) {
    if (!this.appFeatures) {
      throw new Error('AppFeatures has not yet been configured');
    }
    return this.appFeatures.has(appFeatureKey);
  }
}
exports.AppFeaturesService = AppFeaturesService;