"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppFeatures = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _app_features_config_merger = require("./app_features_config_merger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppFeatures {
  constructor(logger, subFeaturesMap, baseKibanaFeature, baseKibanaSubFeatureIds) {
    (0, _defineProperty2.default)(this, "featureConfigMerger", void 0);
    (0, _defineProperty2.default)(this, "appFeatures", void 0);
    (0, _defineProperty2.default)(this, "featuresSetup", void 0);
    this.logger = logger;
    this.baseKibanaFeature = baseKibanaFeature;
    this.baseKibanaSubFeatureIds = baseKibanaSubFeatureIds;
    this.featureConfigMerger = new _app_features_config_merger.AppFeaturesConfigMerger(this.logger, subFeaturesMap);
  }
  init(featuresSetup) {
    this.featuresSetup = featuresSetup;
  }
  setConfig(config) {
    if (this.appFeatures) {
      throw new Error('AppFeatures has already been registered');
    }
    this.registerEnabledKibanaFeatures(config);
  }
  registerEnabledKibanaFeatures(appFeatureConfig) {
    if (this.featuresSetup == null) {
      throw new Error('Cannot sync kibana features as featuresSetup is not present. Did you call init?');
    }
    const completeAppFeatureConfig = this.featureConfigMerger.mergeAppFeatureConfigs(this.baseKibanaFeature, this.baseKibanaSubFeatureIds, Array.from(appFeatureConfig.values()));
    this.logger.debug(JSON.stringify(completeAppFeatureConfig));
    this.featuresSetup.registerKibanaFeature(completeAppFeatureConfig);
  }
}
exports.AppFeatures = AppFeatures;