"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEndpointLicense = exports.validateAgents = exports.LICENSE_TOO_LOW = exports.HOST_NOT_ENROLLED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEndpointLicense = (license, licenseType) => {
  const hasEnterpriseLicense = license.isAtLeast(licenseType);
  if (!hasEnterpriseLicense) {
    return LICENSE_TOO_LOW;
  }
};
exports.validateEndpointLicense = validateEndpointLicense;
const validateAgents = agents => {
  if (!agents.length) {
    return HOST_NOT_ENROLLED;
  }
};
exports.validateAgents = validateAgents;
const LICENSE_TOO_LOW = _i18n.i18n.translate('xpack.securitySolution.responseActionsList.error.licenseTooLow', {
  defaultMessage: 'At least Enterprise license is required to use Response Actions.'
});
exports.LICENSE_TOO_LOW = LICENSE_TOO_LOW;
const HOST_NOT_ENROLLED = _i18n.i18n.translate('xpack.securitySolution.responseActionsList.error.hostNotEnrolled', {
  defaultMessage: 'The host does not have Elastic Defend integration installed'
});
exports.HOST_NOT_ENROLLED = HOST_NOT_ENROLLED;