"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionCreateService = void 0;
var _uuid = require("uuid");
var _ = require("..");
var _write_action_to_indices = require("./write_action_to_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commandToFeatureKeyMap = new Map([['isolate', 'HOST_ISOLATION'], ['unisolate', 'HOST_ISOLATION'], ['kill-process', 'KILL_PROCESS'], ['suspend-process', 'SUSPEND_PROCESS'], ['running-processes', 'RUNNING_PROCESSES'], ['get-file', 'GET_FILE'], ['execute', 'EXECUTE']]);
const returnActionIdCommands = ['isolate', 'unisolate'];
const actionCreateService = (esClient, endpointContext) => {
  const createAction = async (payload, agents, {
    minimumLicenseRequired = 'basic'
  } = {}) => {
    const featureKey = commandToFeatureKeyMap.get(payload.command);
    if (featureKey) {
      endpointContext.service.getFeatureUsageService().notifyUsage(featureKey);
    }

    // create an Action ID and use that to dispatch action to ES & Fleet Server
    const actionID = (0, _uuid.v4)();
    await (0, _write_action_to_indices.writeActionToIndices)({
      actionID,
      agents,
      esClient,
      endpointContext,
      minimumLicenseRequired,
      payload
    });
    const actionId = returnActionIdCommands.includes(payload.command) ? {
      action: actionID
    } : {};
    const data = await (0, _.getActionDetailsById)(esClient, endpointContext.service.getEndpointMetadataService(), actionID);
    return {
      ...actionId,
      ...data
    };
  };
  return {
    createAction,
    createActionFromAlert: async payload => {
      const endpointData = await endpointContext.service.getEndpointMetadataService().getMetadataForEndpoints(esClient, [...new Set(payload.endpoint_ids)]);
      const agentIds = endpointData.map(endpoint => endpoint.elastic.agent.id);
      return createAction(payload, agentIds, {
        minimumLicenseRequired: 'enterprise'
      });
    }
  };
};
exports.actionCreateService = actionCreateService;