"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerActionFileInfoRoute = exports.getActionFileInfoRouteHandler = void 0;
var _endpoint = require("../../../../common/api/endpoint");
var _custom_http_request_error = require("../../../utils/custom_http_request_error");
var _services = require("../../services");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
var _error_handler = require("../error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionFileInfoRouteHandler = endpointContext => {
  const logger = endpointContext.logFactory.get('actionFileInfo');
  return async (context, req, res) => {
    const fleetFiles = await endpointContext.service.getFleetFromHostFilesClient();
    const {
      action_id: requestActionId,
      file_id: fileId
    } = req.params;
    const esClient = (await context.core).elasticsearch.client.asInternalUser;
    try {
      var _agents$at;
      await (0, _services.validateActionId)(esClient, requestActionId);
      const {
        actionId,
        mimeType,
        status,
        size,
        name,
        id,
        agents,
        created
      } = await fleetFiles.get(fileId);
      if (id !== fileId) {
        throw new _custom_http_request_error.CustomHttpRequestError(`Invalid file id [${fileId}] for action [${requestActionId}]`, 400);
      }
      const response = {
        data: {
          name,
          id,
          mimeType,
          size,
          status,
          created,
          actionId,
          agentId: (_agents$at = agents.at(0)) !== null && _agents$at !== void 0 ? _agents$at : ''
        }
      };
      return res.ok({
        body: response
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, res, error);
    }
  };
};
exports.getActionFileInfoRouteHandler = getActionFileInfoRouteHandler;
const registerActionFileInfoRoute = (router, endpointContext) => {
  router.versioned.get({
    access: 'public',
    path: _constants.ACTION_AGENT_FILE_INFO_ROUTE,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _endpoint.EndpointActionFileInfoSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canWriteFileOperations']
  }, endpointContext.logFactory.get('actionFileInfo'), getActionFileInfoRouteHandler(endpointContext)));
};
exports.registerActionFileInfoRoute = registerActionFileInfoRoute;