"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppClient {
  constructor(spaceId, config, kibanaVersion, kibanaBranch) {
    (0, _defineProperty2.default)(this, "alertsIndex", void 0);
    (0, _defineProperty2.default)(this, "signalsIndex", void 0);
    (0, _defineProperty2.default)(this, "spaceId", void 0);
    (0, _defineProperty2.default)(this, "previewIndex", void 0);
    (0, _defineProperty2.default)(this, "sourcererDataViewId", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "getAlertsIndex", () => this.alertsIndex);
    (0, _defineProperty2.default)(this, "getSignalsIndex", () => this.signalsIndex);
    (0, _defineProperty2.default)(this, "getPreviewIndex", () => this.previewIndex);
    (0, _defineProperty2.default)(this, "getSourcererDataViewId", () => this.sourcererDataViewId);
    (0, _defineProperty2.default)(this, "getSpaceId", () => this.spaceId);
    (0, _defineProperty2.default)(this, "getKibanaVersion", () => this.kibanaVersion);
    (0, _defineProperty2.default)(this, "getKibanaBranch", () => this.kibanaBranch);
    const configuredSignalsIndex = config.signalsIndex;
    this.alertsIndex = `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`;
    this.signalsIndex = `${configuredSignalsIndex}-${spaceId}`;
    this.previewIndex = `${_constants.DEFAULT_PREVIEW_INDEX}-${spaceId}`;
    this.sourcererDataViewId = `${_constants.DEFAULT_DATA_VIEW_ID}-${spaceId}`;
    this.spaceId = spaceId;
    this.kibanaVersion = kibanaVersion;
    this.kibanaBranch = kibanaBranch;
  }
}
exports.AppClient = AppClient;