"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabsContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _use_assistant_telemetry = require("../../../../assistant/use_assistant_telemetry");
var _use_conversation_store = require("../../../../assistant/use_conversation_store");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_timeline_events_count = require("../../../../common/hooks/use_timeline_events_count");
var _timeline3 = require("../../../store/timeline");
var _selectors = require("./selectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_license = require("../../../../common/hooks/use_license");
var _translations2 = require("../../../../assistant/content/conversations/translations");
var _actions = require("../../../store/timeline/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const HideShowContainer = _styledComponents.default.div.attrs(({
  $isVisible = false,
  isOverflowYScroll = false
}) => ({
  style: {
    display: $isVisible ? 'flex' : 'none',
    overflow: isOverflowYScroll ? 'hidden scroll' : 'hidden'
  }
}))`
  flex: 1;
`;

/**
 * A HOC which supplies React.Suspense with a fallback component
 * @param Component A component deferred by `React.lazy`
 * @param fallback A fallback component to render while things load. Default is EuiSekeleton for all tabs
 */
const tabWithSuspense = (Component, fallback = /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
  lines: 10
})) => {
  var _Component$displayNam;
  const Comp = /*#__PURE__*/_react2.default.forwardRef((props, ref) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
    fallback: fallback
  }, /*#__PURE__*/_react2.default.createElement(Component, (0, _extends2.default)({}, props, {
    ref: ref
  }))));
  Comp.displayName = `${(_Component$displayNam = Component.displayName) !== null && _Component$displayNam !== void 0 ? _Component$displayNam : 'Tab'}WithSuspense`;
  return Comp;
};
const AssistantTabContainer = _styledComponents.default.div`
  overflow-y: auto;
  width: 100%;
`;
const QueryTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../query_tab_content')))));
const EqlTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../eql_tab_content')))));
const GraphTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../graph_tab_content')))));
const NotesTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../notes_tab_content')))));
const PinnedTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pinned_tab_content')))));
const SessionTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../session_tab_content')))));
const EsqlTab = tabWithSuspense( /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../esql_tab_content')))));
const AssistantTab = /*#__PURE__*/(0, _react2.memo)(({
  shouldRefocusPrompt,
  setConversationId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(AssistantTabContainer, null, /*#__PURE__*/_react2.default.createElement(_elasticAssistant.Assistant, {
  conversationId: _translations2.TIMELINE_CONVERSATION_TITLE,
  embeddedLayout: true,
  setConversationId: setConversationId,
  shouldRefocusPrompt: shouldRefocusPrompt
}))));
AssistantTab.displayName = 'AssistantTab';
const ActiveTimelineTab = /*#__PURE__*/(0, _react2.memo)(({
  activeTimelineTab,
  renderCellValue,
  rowRenderers,
  timelineId,
  timelineType,
  setConversationId,
  showTimeline
}) => {
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const isEsqlSettingEnabled = (0, _kibana.useKibana)().services.configSettings.ESQLEnabled;
  const getTab = (0, _react2.useCallback)(tab => {
    switch (tab) {
      case _timeline.TimelineTabs.graph:
        return /*#__PURE__*/_react2.default.createElement(GraphTab, {
          timelineId: timelineId
        });
      case _timeline.TimelineTabs.notes:
        return /*#__PURE__*/_react2.default.createElement(NotesTab, {
          timelineId: timelineId
        });
      case _timeline.TimelineTabs.session:
        return /*#__PURE__*/_react2.default.createElement(SessionTab, {
          timelineId: timelineId
        });
      default:
        return null;
    }
  }, [timelineId]);
  const isGraphOrNotesTabs = (0, _react2.useMemo)(() => [_timeline.TimelineTabs.graph, _timeline.TimelineTabs.notes, _timeline.TimelineTabs.session].includes(activeTimelineTab), [activeTimelineTab]);
  const {
    conversations
  } = (0, _use_conversation_store.useConversationStore)();
  const hasTimelineConversationStarted = (0, _react2.useMemo)(() => conversations[_translations2.TIMELINE_CONVERSATION_TITLE].messages.length > 0, [conversations]);

  /* Future developer -> why are we doing that
   * It is really expansive to re-render the QueryTab because the drag/drop
   * Therefore, we are only hiding its dom when switching to another tab
   * to avoid mounting/un-mounting === re-render
   */
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: _timeline.TimelineTabs.query === activeTimelineTab,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.query}`
  }, /*#__PURE__*/_react2.default.createElement(QueryTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })), showTimeline && isEsqlSettingEnabled && activeTimelineTab === _timeline.TimelineTabs.esql && /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: true,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.esql}`
  }, /*#__PURE__*/_react2.default.createElement(EsqlTab, {
    timelineId: timelineId
  })), /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: _timeline.TimelineTabs.pinned === activeTimelineTab,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.pinned}`
  }, /*#__PURE__*/_react2.default.createElement(PinnedTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })), timelineType === _timeline2.TimelineType.default && /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: _timeline.TimelineTabs.eql === activeTimelineTab,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.eql}`
  }, /*#__PURE__*/_react2.default.createElement(EqlTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })), /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: isGraphOrNotesTabs,
    isOverflowYScroll: activeTimelineTab === _timeline.TimelineTabs.session,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.graph}-${_timeline.TimelineTabs.notes}`
  }, isGraphOrNotesTabs && getTab(activeTimelineTab)), hasAssistantPrivilege && /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: activeTimelineTab === _timeline.TimelineTabs.securityAssistant,
    isOverflowYScroll: activeTimelineTab === _timeline.TimelineTabs.securityAssistant,
    "data-test-subj": `timeline-tab-content-security-assistant`,
    css: (0, _react.css)`
              overflow: hidden !important;
            `
  }, (activeTimelineTab === _timeline.TimelineTabs.securityAssistant || hasTimelineConversationStarted) && /*#__PURE__*/_react2.default.createElement(AssistantTab, {
    setConversationId: setConversationId,
    shouldRefocusPrompt: showTimeline && activeTimelineTab === _timeline.TimelineTabs.securityAssistant
  })));
});
ActiveTimelineTab.displayName = 'ActiveTimelineTab';
const CountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiBetaBadge = (0, _styledComponents.default)(_eui.EuiBetaBadge)`
  vertical-align: middle;
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};

  &:hover {
    cursor: pointer;
  }
`;
const StyledEuiTab = (0, _styledComponents.default)(_eui.EuiTab)`
  .euiTab__content {
    align-items: center;
    display: flex;
    flex-direction: row;
    white-space: pre;
  }

  :focus {
    text-decoration: none;

    > span > span {
      text-decoration: underline;
    }
  }
`;
const StyledEuiTabs = (0, _styledComponents.default)(_eui.EuiTabs)`
  padding-inline: ${props => props.theme.eui.euiSizeM};
`;
const TabsContentComponent = ({
  renderCellValue,
  rowRenderers,
  timelineId,
  timelineFullScreen,
  timelineType,
  graphEventId,
  sessionViewConfig,
  timelineDescription
}) => {
  const isEsqlTabInTimelineDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('timelineEsqlTabDisabled');
  const isEsqlSettingEnabled = (0, _kibana.useKibana)().services.configSettings.ESQLEnabled;
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const getActiveTab = (0, _react2.useMemo)(() => (0, _selectors.getActiveTabSelector)(), []);
  const getShowTimeline = (0, _react2.useMemo)(() => (0, _selectors.getShowTimelineSelector)(), []);
  const getNumberOfPinnedEvents = (0, _react2.useMemo)(() => (0, _selectors.getPinnedEventSelector)(), []);
  const getAppNotes = (0, _react2.useMemo)(() => (0, _selectors.getNotesSelector)(), []);
  const getTimelineNoteIds = (0, _react2.useMemo)(() => (0, _selectors.getNoteIdsSelector)(), []);
  const getTimelinePinnedEventNotes = (0, _react2.useMemo)(() => (0, _selectors.getEventIdToNoteIdsSelector)(), []);
  const activeTab = (0, _use_selector.useShallowEqualSelector)(state => getActiveTab(state, timelineId));
  const showTimeline = (0, _use_selector.useShallowEqualSelector)(state => getShowTimeline(state, timelineId));
  const numberOfPinnedEvents = (0, _use_selector.useShallowEqualSelector)(state => getNumberOfPinnedEvents(state, timelineId));
  const globalTimelineNoteIds = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNoteIds(state, timelineId));
  const eventIdToNoteIds = (0, _use_selector.useDeepEqualSelector)(state => getTimelinePinnedEventNotes(state, timelineId));
  const appNotes = (0, _use_selector.useDeepEqualSelector)(state => getAppNotes(state));
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const [conversationId, setConversationId] = (0, _react2.useState)(_translations2.TIMELINE_CONVERSATION_TITLE);
  const {
    reportAssistantInvoked
  } = (0, _use_assistant_telemetry.useAssistantTelemetry)();
  const allTimelineNoteIds = (0, _react2.useMemo)(() => {
    const eventNoteIds = Object.values(eventIdToNoteIds).reduce((acc, v) => [...acc, ...v], []);
    return [...globalTimelineNoteIds, ...eventNoteIds];
  }, [globalTimelineNoteIds, eventIdToNoteIds]);
  const numberOfNotes = (0, _react2.useMemo)(() => appNotes.filter(appNote => allTimelineNoteIds.includes(appNote.id)).length + ((0, _fp.isEmpty)(timelineDescription) ? 0 : 1), [appNotes, allTimelineNoteIds, timelineDescription]);
  const setActiveTab = (0, _react2.useCallback)(tab => {
    dispatch(_timeline3.timelineActions.setActiveTabTimeline({
      id: timelineId,
      activeTab: tab
    }));
  }, [dispatch, timelineId]);
  const setQueryAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.query);
  }, [setActiveTab]);
  const setEqlAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.eql);
  }, [setActiveTab]);
  const setGraphAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.graph);
  }, [setActiveTab]);
  const setNotesAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.notes);
  }, [setActiveTab]);
  const setPinnedAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.pinned);
  }, [setActiveTab]);
  const setSessionAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.session);
  }, [setActiveTab]);
  const setSecurityAssistantAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.securityAssistant);
    if (activeTab !== _timeline.TimelineTabs.securityAssistant) {
      reportAssistantInvoked({
        conversationId,
        invokedBy: _translations2.TIMELINE_CONVERSATION_TITLE
      });
    }
  }, [activeTab, conversationId, reportAssistantInvoked, setActiveTab]);
  const setEsqlAsActiveTab = (0, _react2.useCallback)(() => {
    dispatch((0, _actions.initializeTimelineSettings)({
      id: timelineId
    }));
    setActiveTab(_timeline.TimelineTabs.esql);
  }, [setActiveTab, dispatch, timelineId]);
  (0, _react2.useEffect)(() => {
    if (!graphEventId && activeTab === _timeline.TimelineTabs.graph) {
      setQueryAsActiveTab();
    }
  }, [activeTab, graphEventId, setQueryAsActiveTab]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, !timelineFullScreen && /*#__PURE__*/_react2.default.createElement(StyledEuiTabs, {
    className: "eui-scrollBar"
  }, /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.query}`,
    onClick: setQueryAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.query,
    disabled: false,
    key: _timeline.TimelineTabs.query
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.QUERY_TAB), showTimeline && /*#__PURE__*/_react2.default.createElement(_use_timeline_events_count.TimelineEventsCountBadge, null)), !isEsqlTabInTimelineDisabled && isEsqlSettingEnabled && /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.esql}`,
    onClick: setEsqlAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.esql,
    disabled: false,
    key: _timeline.TimelineTabs.esql
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.DISCOVER_ESQL_IN_TIMELINE_TAB), /*#__PURE__*/_react2.default.createElement(StyledEuiBetaBadge, {
    label: i18n.DISCOVER_ESQL_IN_TIMELINE_TECHNICAL_PREVIEW,
    size: "s",
    iconType: "beaker",
    tooltipContent: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.timeline.tabs.discoverEsqlInTimeline.technicalPreviewTooltip",
      defaultMessage: "This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features."
    })
  })), timelineType === _timeline2.TimelineType.default && /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.eql}`,
    onClick: setEqlAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.eql,
    disabled: false,
    key: _timeline.TimelineTabs.eql
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.EQL_TAB), showTimeline && /*#__PURE__*/_react2.default.createElement(_use_timeline_events_count.EqlEventsCountBadge, null)), /*#__PURE__*/_react2.default.createElement(_eui.EuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.graph}`,
    onClick: setGraphAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.graph,
    disabled: !graphEventId,
    key: _timeline.TimelineTabs.graph
  }, i18n.ANALYZER_TAB), isEnterprisePlus && /*#__PURE__*/_react2.default.createElement(_eui.EuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.session}`,
    onClick: setSessionAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.session,
    disabled: sessionViewConfig === null,
    key: _timeline.TimelineTabs.session
  }, i18n.SESSION_TAB), /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.notes}`,
    onClick: setNotesAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.notes,
    disabled: timelineType === _timeline2.TimelineType.template,
    key: _timeline.TimelineTabs.notes
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.NOTES_TAB), showTimeline && numberOfNotes > 0 && timelineType === _timeline2.TimelineType.default && /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(CountBadge, null, numberOfNotes))), /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.pinned}`,
    onClick: setPinnedAsActiveTab,
    disabled: timelineType === _timeline2.TimelineType.template,
    isSelected: activeTab === _timeline.TimelineTabs.pinned,
    key: _timeline.TimelineTabs.pinned
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.PINNED_TAB), showTimeline && numberOfPinnedEvents > 0 && timelineType === _timeline2.TimelineType.default && /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(CountBadge, null, numberOfPinnedEvents))), hasAssistantPrivilege && /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.securityAssistant}`,
    onClick: setSecurityAssistantAsActiveTab,
    disabled: timelineType === _timeline2.TimelineType.template,
    isSelected: activeTab === _timeline.TimelineTabs.securityAssistant,
    key: _timeline.TimelineTabs.securityAssistant
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.SECURITY_ASSISTANT))), /*#__PURE__*/_react2.default.createElement(ActiveTimelineTab, {
    activeTimelineTab: activeTab,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    timelineType: timelineType,
    timelineDescription: timelineDescription,
    setConversationId: setConversationId,
    showTimeline: showTimeline
  }));
};
const TabsContent = /*#__PURE__*/(0, _react2.memo)(TabsContentComponent);
exports.TabsContent = TabsContent;