"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_session_view = require("./use_session_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaxWidthFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 100%;
`;
const SessionViewWrapper = _styledComponents.default.div`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
`;
const MaxWidthPageFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-width: 100%;
  box-sizing: border-box;
`;
const VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const StyledFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
  height: 100%;
  min-width: 320px;
`;
const SessionTabContent = ({
  timelineId
}) => {
  const [height, setHeight] = (0, _react.useState)(0);
  const measuredRef = (0, _react.useCallback)(node => {
    if (node !== null) {
      setHeight(node.getBoundingClientRect().height);
    }
  }, []);
  const {
    Navigation
  } = (0, _use_session_view.useSessionViewNavigation)({
    scopeId: timelineId
  });
  const {
    SessionView,
    shouldShowDetailsPanel,
    DetailsPanel
  } = (0, _use_session_view.useSessionView)({
    scopeId: timelineId,
    height
  });
  return /*#__PURE__*/_react.default.createElement(MaxWidthPageFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "none",
    ref: measuredRef,
    "data-test-subj": "timeline-session-content"
  }, /*#__PURE__*/_react.default.createElement(MaxWidthFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), Navigation, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(SessionViewWrapper, null, SessionView)), shouldShowDetailsPanel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(VerticalRule, null), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    grow: 1
  }, DetailsPanel)));
};

// eslint-disable-next-line import/no-default-export
var _default = SessionTabContent;
exports.default = _default;
module.exports = exports.default;