"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewTemplateTimelineComponent = exports.NewTemplateTimeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _use_create_timeline = require("./use_create_timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewTemplateTimelineComponent = ({
  onClick,
  outline,
  title,
  timelineId = _timeline.TimelineId.active
}) => {
  const {
    getButton
  } = (0, _use_create_timeline.useCreateTimelineButton)({
    timelineId,
    timelineType: _timeline2.TimelineType.template,
    onClick
  });
  const button = getButton({
    outline,
    title
  });
  return button;
};
exports.NewTemplateTimelineComponent = NewTemplateTimelineComponent;
const NewTemplateTimeline = /*#__PURE__*/_react.default.memo(NewTemplateTimelineComponent);
exports.NewTemplateTimeline = NewTemplateTimeline;
NewTemplateTimeline.displayName = 'NewTemplateTimeline';