"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPinIcon = exports.getDefaultAriaLabel = exports.Pin = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("../body/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPinIcon = pinned => pinned ? 'pinFilled' : 'pin';
exports.getPinIcon = getPinIcon;
const getDefaultAriaLabel = ({
  isAlert,
  isTemplate,
  isPinned
}) => {
  if (isTemplate) {
    return i18n.DISABLE_PIN(isAlert);
  } else if (isPinned) {
    return i18n.PINNED(isAlert);
  } else {
    return i18n.UNPINNED(isAlert);
  }
};
exports.getDefaultAriaLabel = getDefaultAriaLabel;
const Pin = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  allowUnpinning,
  isAlert,
  isDisabled,
  onClick = _fp.noop,
  pinned,
  timelineType
}) => {
  const isTemplate = timelineType === _timeline.TimelineType.template;
  const defaultAriaLabel = getDefaultAriaLabel({
    isAlert,
    isTemplate,
    isPinned: pinned
  });
  const pinAriaLabel = ariaLabel != null ? ariaLabel : defaultAriaLabel;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": pinAriaLabel,
    "data-test-subj": "pin",
    iconType: getPinIcon(pinned),
    onClick: onClick,
    isDisabled: isDisabled || isTemplate || !allowUnpinning,
    size: "s"
  });
});
exports.Pin = Pin;
Pin.displayName = 'Pin';