"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DiscoverTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = require("styled-components");
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _use_discover_in_timeline_context = require("../../../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _kibana = require("../../../../common/lib/kibana");
var _use_discover_state = require("./use_discover_state");
var _model = require("../../../../common/store/sourcerer/model");
var _use_set_discover_customizations = require("./customizations/use_set_discover_customizations");
var _styles = require("./styles");
var _timeline = require("../../../store/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _defaults = require("../../../store/timeline/defaults");
var _utils = require("./utils");
var _actions = require("../../../store/timeline/actions");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HideSearchSessionIndicatorBreadcrumbIcon = (0, _styledComponents.createGlobalStyle)`
  [data-test-subj='searchSessionIndicator'] {
    display: none;
  }
`;
const DiscoverTabContent = ({
  timelineId
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services: {
      customDataService: discoverDataService,
      discover,
      dataViews: dataViewService,
      savedSearch: savedSearchService
    }
  } = (0, _kibana.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    dataViewId
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const [dataView, setDataView] = (0, _react.useState)();
  const [discoverTimerange, setDiscoverTimerange] = (0, _react.useState)();
  const discoverAppStateSubscription = (0, _react.useRef)();
  const discoverInternalStateSubscription = (0, _react.useRef)();
  const discoverSavedSearchStateSubscription = (0, _react.useRef)();
  const discoverTimerangeSubscription = (0, _react.useRef)();
  const {
    discoverStateContainer,
    setDiscoverStateContainer,
    getAppStateFromSavedSearch,
    updateSavedSearch,
    initializeLocalSavedSearch,
    restoreDiscoverAppStateFromSavedSearch,
    resetDiscoverAppState,
    getDefaultDiscoverAppState
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const {
    discoverAppState,
    discoverSavedSearchState,
    setDiscoverSavedSearchState,
    setDiscoverInternalState,
    setDiscoverAppState
  } = (0, _use_discover_state.useDiscoverState)();
  const discoverCustomizationCallbacks = (0, _use_set_discover_customizations.useSetDiscoverCustomizationCallbacks)();
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const timeline = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
  });
  const {
    status,
    savedSearchId,
    activeTab,
    savedObjectId,
    title,
    description,
    isDiscoverSavedSearchLoaded = false
  } = timeline;
  const setSavedSearchLoaded = (0, _react.useCallback)(value => {
    dispatch((0, _actions.setIsDiscoverSavedSearchLoaded)({
      id: timelineId,
      isDiscoverSavedSearchLoaded: value
    }));
  }, [dispatch, timelineId]);
  const {
    data: savedSearchById,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: ['savedSearchById', savedSearchId !== null && savedSearchId !== void 0 ? savedSearchId : ''],
    queryFn: () => savedSearchId ? savedSearchService.get(savedSearchId) : Promise.resolve(null)
  });
  (0, _react.useEffect)(() => {
    if (!savedObjectId) return;
    setSavedSearchLoaded(false);
  }, [savedObjectId, setSavedSearchLoaded]);
  (0, _react.useEffect)(() => {
    if (isFetching) return; // no-op is fetch is in progress
    if (isDiscoverSavedSearchLoaded) return; // no-op if saved search has been already loaded
    if (!savedSearchById) {
      // nothing to restore if savedSearchById is null
      if (status === 'draft') {
        resetDiscoverAppState().then(() => {
          setSavedSearchLoaded(true);
        });
      } else {
        dispatch((0, _actions.endTimelineSaving)({
          id: timelineId
        }));
        setSavedSearchLoaded(true);
      }
      return;
    }
    restoreDiscoverAppStateFromSavedSearch(savedSearchById);
    setSavedSearchLoaded(true);
  }, [discoverStateContainer, savedSearchId, isDiscoverSavedSearchLoaded, status, activeTab, resetDiscoverAppState, savedSearchById, getAppStateFromSavedSearch, restoreDiscoverAppStateFromSavedSearch, isFetching, setSavedSearchLoaded, dispatch, timelineId]);
  const getCombinedDiscoverSavedSearchState = (0, _react.useCallback)(() => {
    var _discoverStateContain, _discoverStateContain2, _discoverStateContain3, _discoverStateContain4, _discoverStateContain5, _discoverStateContain6;
    if (!discoverSavedSearchState) return;
    return {
      ...((_discoverStateContain = (_discoverStateContain2 = discoverStateContainer.current) === null || _discoverStateContain2 === void 0 ? void 0 : _discoverStateContain2.savedSearchState.getState()) !== null && _discoverStateContain !== void 0 ? _discoverStateContain : discoverSavedSearchState),
      timeRange: discoverDataService.query.timefilter.timefilter.getTime(),
      refreshInterval: (_discoverStateContain3 = discoverStateContainer.current) === null || _discoverStateContain3 === void 0 ? void 0 : (_discoverStateContain4 = _discoverStateContain3.globalState.get()) === null || _discoverStateContain4 === void 0 ? void 0 : _discoverStateContain4.refreshInterval,
      breakdownField: (_discoverStateContain5 = discoverStateContainer.current) === null || _discoverStateContain5 === void 0 ? void 0 : _discoverStateContain5.appState.getState().breakdownField,
      rowsPerPage: (_discoverStateContain6 = discoverStateContainer.current) === null || _discoverStateContain6 === void 0 ? void 0 : _discoverStateContain6.appState.getState().rowsPerPage,
      title: (0, _translations.GET_TIMELINE_DISCOVER_SAVED_SEARCH_TITLE)(title),
      description
    };
  }, [discoverSavedSearchState, discoverStateContainer, discoverDataService.query.timefilter.timefilter, title, description]);
  const combinedDiscoverSavedSearchStateRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    if (isFetching) return;
    if (!isDiscoverSavedSearchLoaded) return;
    if (!savedObjectId) return;
    if (!status || status === 'draft') return;
    const latestState = getCombinedDiscoverSavedSearchState();
    const index = latestState === null || latestState === void 0 ? void 0 : latestState.searchSource.getField('index');
    /* when a new timeline is loaded, a new discover instance is loaded which first emits
     * discover's initial state which is then updated in the saved search. We want to avoid that.*/
    if (!index) return;
    if (!latestState || combinedDiscoverSavedSearchStateRef.current === latestState) return;
    if ((0, _lodash.isEqualWith)(latestState, savedSearchById, _utils.savedSearchComparator)) return;
    updateSavedSearch(latestState, timelineId);
    combinedDiscoverSavedSearchStateRef.current = latestState;
  }, [getCombinedDiscoverSavedSearchState, savedSearchById, updateSavedSearch, isDiscoverSavedSearchLoaded, activeTab, status, discoverTimerange, savedObjectId, isFetching, timelineId, dispatch]);
  (0, _react.useEffect)(() => {
    if (!dataViewId) return;
    dataViewService.get(dataViewId).then(setDataView);
  }, [dataViewId, dataViewService]);
  (0, _react.useEffect)(() => {
    const unSubscribeAll = () => {
      [discoverAppStateSubscription.current, discoverInternalStateSubscription.current, discoverSavedSearchStateSubscription.current, discoverTimerangeSubscription.current].forEach(sub => {
        if (sub) sub.unsubscribe();
      });
    };
    return unSubscribeAll;
  }, [discoverStateContainer]);
  const initialDiscoverCustomizationCallback = (0, _react.useCallback)(async ({
    stateContainer
  }) => {
    var _ref, _savedSearchAppState$, _savedSearchAppState, _savedSearchAppState2;
    setDiscoverStateContainer(stateContainer);
    let savedSearchAppState;
    if (savedSearchId) {
      const localSavedSearch = await savedSearchService.get(savedSearchId);
      initializeLocalSavedSearch(localSavedSearch, timelineId);
      savedSearchAppState = getAppStateFromSavedSearch(localSavedSearch);
    }
    const defaultDiscoverAppState = await getDefaultDiscoverAppState();
    const finalAppState = (_ref = (_savedSearchAppState$ = (_savedSearchAppState = savedSearchAppState) === null || _savedSearchAppState === void 0 ? void 0 : _savedSearchAppState.appState) !== null && _savedSearchAppState$ !== void 0 ? _savedSearchAppState$ : discoverAppState) !== null && _ref !== void 0 ? _ref : defaultDiscoverAppState;
    const urlAppState = stateContainer.appState.isEmptyURL() ? undefined : stateContainer.appState.getState();
    const hasESQLURlState = (urlAppState === null || urlAppState === void 0 ? void 0 : urlAppState.query) && 'esql' in urlAppState.query;

    /*
     * Url state should NOT apply if there is already a saved search being loaded
     * */
    const shouldApplyESQLUrlState = !((_savedSearchAppState2 = savedSearchAppState) !== null && _savedSearchAppState2 !== void 0 && _savedSearchAppState2.appState) && hasESQLURlState;
    if (!shouldApplyESQLUrlState) {
      /*
       * If url state applies, it should be a no-op and there is no need to update the state container.
       * Discover should automatically pick up url state
       * */
      stateContainer.appState.set(finalAppState);
      await stateContainer.appState.replaceUrlState(finalAppState);
    }
    const unsubscribeState = stateContainer.appState.state$.subscribe({
      next: setDiscoverAppState
    });
    const internalStateSubscription = stateContainer.internalState.state$.subscribe({
      next: setDiscoverInternalState
    });
    const savedSearchStateSub = stateContainer.savedSearchState.getHasChanged$().subscribe({
      next: hasChanged => {
        if (hasChanged) {
          const latestSavedSearchState = stateContainer.savedSearchState.getState();
          setDiscoverSavedSearchState(latestSavedSearchState);
        }
      }
    });
    const timeRangeSub = discoverDataService.query.timefilter.timefilter.getTimeUpdate$().subscribe({
      next: () => {
        setDiscoverTimerange(discoverDataService.query.timefilter.timefilter.getTime());
      }
    });
    discoverAppStateSubscription.current = unsubscribeState;
    discoverInternalStateSubscription.current = internalStateSubscription;
    discoverSavedSearchStateSubscription.current = savedSearchStateSub;
    discoverTimerangeSubscription.current = timeRangeSub;
  }, [discoverAppState, setDiscoverSavedSearchState, setDiscoverInternalState, setDiscoverAppState, setDiscoverStateContainer, getAppStateFromSavedSearch, discoverDataService.query.timefilter.timefilter, savedSearchId, savedSearchService, getDefaultDiscoverAppState, timelineId, initializeLocalSavedSearch]);
  const customizationsCallbacks = (0, _react.useMemo)(() => [initialDiscoverCustomizationCallback, ...discoverCustomizationCallbacks], [initialDiscoverCustomizationCallback, discoverCustomizationCallbacks]);
  const services = (0, _react.useMemo)(() => ({
    data: discoverDataService,
    filterManager: discoverDataService.query.filterManager,
    timefilter: discoverDataService.query.timefilter.timefilter
  }), [discoverDataService]);
  const DiscoverContainer = discover.DiscoverContainer;
  const isLoading = Boolean(!dataView) || !isDiscoverSavedSearchLoaded;
  return /*#__PURE__*/_react.default.createElement(_styles.EmbeddedDiscoverContainer, {
    "data-test-subj": "timeline-embedded-discover"
  }, /*#__PURE__*/_react.default.createElement(HideSearchSessionIndicatorBreadcrumbIcon, null), /*#__PURE__*/_react.default.createElement(DiscoverContainer, {
    overrideServices: services,
    scopedHistory: history,
    customizationCallbacks: customizationsCallbacks,
    isLoading: isLoading
  }));
};

// eslint-disable-next-line import/no-default-export
exports.DiscoverTabContent = DiscoverTabContent;
var _default = DiscoverTabContent;
exports.default = _default;