"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFileEvent = exports.getValues = exports.findItem = exports.deleteItemIdx = exports.TokensFlexItem = exports.Details = exports.DETAILS_CLASS_NAME = void 0;
exports.isNillEmptyOrNotFinite = isNillEmptyOrNotFinite;
exports.showVia = exports.isProcessStoppedOrTerminationEvent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteItemIdx = (data, idx) => [...data.slice(0, idx), ...data.slice(idx + 1)];
exports.deleteItemIdx = deleteItemIdx;
const findItem = (data, field) => data.findIndex(d => d.field === field);
exports.findItem = findItem;
const getValues = (field, data) => {
  const obj = data.find(d => d.field === field);
  if (obj != null && obj.value != null) {
    return obj.value;
  }
  return undefined;
};
exports.getValues = getValues;
const DETAILS_CLASS_NAME = 'details';
exports.DETAILS_CLASS_NAME = DETAILS_CLASS_NAME;
const Details = _styledComponents.default.div.attrs(() => ({
  className: DETAILS_CLASS_NAME
}))`
  margin: 5px 0 5px 10px;
  & .euiBadge {
    margin: 2px 0 2px 0;
  }
  & .euiFlexGroup {
    justify-content: center;
  }
`;
exports.Details = Details;
Details.displayName = 'Details';
const TokensFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 3px;
`;
exports.TokensFlexItem = TokensFlexItem;
TokensFlexItem.displayName = 'TokensFlexItem';
function isNillEmptyOrNotFinite(value) {
  return (0, _fp.isNumber)(value) ? !isFinite(value) : (0, _fp.isEmpty)(value);
}
const isFileEvent = ({
  eventCategory,
  eventDataset
}) => (eventCategory === null || eventCategory === void 0 ? void 0 : eventCategory.toLowerCase()) === 'file' || (eventDataset === null || eventDataset === void 0 ? void 0 : eventDataset.toLowerCase()) === 'file' || (eventDataset === null || eventDataset === void 0 ? void 0 : eventDataset.toLowerCase()) === 'endpoint.events.file';
exports.isFileEvent = isFileEvent;
const isProcessStoppedOrTerminationEvent = eventAction => ['process_stopped', 'termination_event'].includes(`${eventAction}`.toLowerCase());
exports.isProcessStoppedOrTerminationEvent = isProcessStoppedOrTerminationEvent;
const showVia = eventAction => ['created', 'creation', 'deleted', 'deletion', 'file_create_event', 'file_delete_event', 'files-encrypted', 'load', 'modification', 'overwrite', 'rename'].includes(`${eventAction}`.toLowerCase());
exports.showVia = showVia;