"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventColumnView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../../styles");
var _data_driven_columns = require("../data_driven_columns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventColumnView = /*#__PURE__*/_react.default.memo(({
  id,
  actionsColumnWidth,
  ariaRowindex,
  columnHeaders,
  data,
  ecsData,
  eventIdToNoteIds,
  isEventPinned = false,
  isEventViewer = false,
  loadingEventIds,
  notesCount,
  onEventDetailsPanelOpened,
  onRowSelected,
  refetch,
  hasRowRenderers,
  onRuleChange,
  renderCellValue,
  selectedEventIds,
  showCheckboxes,
  showNotes,
  tabType,
  timelineId,
  toggleShowNotes,
  leadingControlColumns,
  trailingControlColumns,
  setEventsLoading,
  setEventsDeleted
}) => {
  // Each action button shall announce itself to screen readers via an `aria-label`
  // in the following format:
  // "button description, for the event in row {ariaRowindex}, with columns {columnValues}",
  // so we combine the column values here:
  const columnValues = (0, _react.useMemo)(() => columnHeaders.map(header => {
    var _getMappedNonEcsValue;
    return (_getMappedNonEcsValue = (0, _data_driven_columns.getMappedNonEcsValue)({
      data,
      fieldName: header.id
    })) !== null && _getMappedNonEcsValue !== void 0 ? _getMappedNonEcsValue : [];
  }).join(' '), [columnHeaders, data]);
  const leadingActionCells = (0, _react.useMemo)(() => leadingControlColumns ? leadingControlColumns.map(column => column.rowCellRender) : [], [leadingControlColumns]);
  const LeadingActions = (0, _react.useMemo)(() => leadingActionCells.map((Action, index) => {
    const width = leadingControlColumns[index].width ? leadingControlColumns[index].width : actionsColumnWidth;
    return /*#__PURE__*/_react.default.createElement(_styles.EventsTdGroupActions, {
      width: width,
      "data-test-subj": "event-actions-container",
      tabIndex: 0,
      key: index
    }, Action && /*#__PURE__*/_react.default.createElement(Action, {
      width: width,
      rowIndex: ariaRowindex,
      ariaRowindex: ariaRowindex,
      checked: Object.keys(selectedEventIds).includes(id),
      columnId: leadingControlColumns[index].id || '',
      columnValues: columnValues,
      onRowSelected: onRowSelected,
      "data-test-subj": "actions",
      eventId: id,
      data: data,
      index: index,
      ecsData: ecsData,
      loadingEventIds: loadingEventIds,
      onEventDetailsPanelOpened: onEventDetailsPanelOpened,
      showCheckboxes: showCheckboxes,
      eventIdToNoteIds: eventIdToNoteIds,
      isEventPinned: isEventPinned,
      isEventViewer: isEventViewer,
      onRuleChange: onRuleChange,
      refetch: refetch,
      showNotes: showNotes,
      tabType: tabType,
      timelineId: timelineId,
      toggleShowNotes: toggleShowNotes,
      setEventsLoading: setEventsLoading,
      setEventsDeleted: setEventsDeleted
    }));
  }), [actionsColumnWidth, ariaRowindex, columnValues, data, ecsData, eventIdToNoteIds, id, isEventPinned, isEventViewer, leadingActionCells, leadingControlColumns, loadingEventIds, onEventDetailsPanelOpened, onRowSelected, onRuleChange, refetch, selectedEventIds, showCheckboxes, showNotes, tabType, timelineId, toggleShowNotes, setEventsLoading, setEventsDeleted]);
  return /*#__PURE__*/_react.default.createElement(_styles.EventsTrData, {
    "data-test-subj": "event-column-view"
  }, LeadingActions, /*#__PURE__*/_react.default.createElement(_data_driven_columns.DataDrivenColumns, {
    id: id,
    actionsColumnWidth: actionsColumnWidth,
    ariaRowindex: ariaRowindex,
    columnHeaders: columnHeaders,
    data: data,
    ecsData: ecsData,
    hasRowRenderers: hasRowRenderers,
    notesCount: notesCount,
    renderCellValue: renderCellValue,
    tabType: tabType,
    timelineId: timelineId,
    trailingControlColumns: trailingControlColumns,
    leadingControlColumns: leadingControlColumns,
    checked: Object.keys(selectedEventIds).includes(id),
    columnValues: columnValues,
    onRowSelected: onRowSelected,
    "data-test-subj": "actions",
    loadingEventIds: loadingEventIds,
    onEventDetailsPanelOpened: onEventDetailsPanelOpened,
    showCheckboxes: showCheckboxes,
    eventIdToNoteIds: eventIdToNoteIds,
    isEventPinned: isEventPinned,
    isEventViewer: isEventViewer,
    refetch: refetch,
    onRuleChange: onRuleChange,
    selectedEventIds: selectedEventIds,
    showNotes: showNotes,
    toggleShowNotes: toggleShowNotes,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted
  }));
});
exports.EventColumnView = EventColumnView;
EventColumnView.displayName = 'EventColumnView';