"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservedUser = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _basic_table = require("../../../../common/components/ml/tables/basic_table");
var _formatted_date = require("../../../../common/components/formatted_date");
var _columns = require("./columns");
var _constants = require("./constants");
var _inspect = require("../../../../common/components/inspect");
var _observed_details = require("../../../../explore/users/containers/users/observed_details");
var _use_observed_user_items = require("./hooks/use_observed_user_items");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservedUser = ({
  observedUser,
  contextID,
  scopeId,
  isDraggable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const observedItems = (0, _use_observed_user_items.useObservedUserItems)(observedUser);
  const observedUserTableColumns = (0, _react.useMemo)(() => (0, _columns.getObservedUserTableColumns)(contextID, scopeId, isDraggable), [contextID, scopeId, isDraggable]);
  const xsFontSize = (0, _eui.useEuiFontSize)('xxs').fontSize;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    isLoading: observedUser.isLoading,
    id: "observedUser-data",
    "data-test-subj": "observedUser-data",
    buttonProps: {
      'data-test-subj': 'observedUser-accordion-button',
      css: (0, _react2.css)`
              color: ${euiTheme.colors.primary};
            `
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.OBSERVED_DATA_TITLE)),
    extraAction: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      css: (0, _react2.css)`
                  margin-right: ${euiTheme.size.s};
                `
    }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
      queryId: _observed_details.OBSERVED_USER_QUERY_ID,
      title: i18n.OBSERVED_USER_INSPECT_TITLE
    })), observedUser.lastSeen.date && /*#__PURE__*/_react.default.createElement("span", {
      css: (0, _react2.css)`
                    font-size: ${xsFontSize};
                  `
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.timeline.userDetails.observedUserUpdatedTime",
      defaultMessage: "Updated {time}",
      values: {
        time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: observedUser.lastSeen.date,
          dateFormat: "MMM D, YYYY",
          relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS
        })
      }
    }))),
    css: (0, _react2.css)`
            .euiAccordion__optionalAction {
              margin-left: auto;
            }
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_basic_table.BasicTable, {
    loading: observedUser.isLoading || observedUser.firstSeen.isLoading || observedUser.lastSeen.isLoading || observedUser.anomalies.isLoading,
    "data-test-subj": "observedUser-table",
    columns: observedUserTableColumns,
    items: observedItems
  }))));
};
exports.ObservedUser = ObservedUser;