"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimelineModalBody = exports.HeaderContainer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _search_row = require("../search_row");
var _timelines_table = require("../timelines_table");
var _title_row = require("../title_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderContainer = _styledComponents.default.div`
  width: 100%;
`;
exports.HeaderContainer = HeaderContainer;
HeaderContainer.displayName = 'HeaderContainer';
const OpenTimelineModalBody = /*#__PURE__*/(0, _react.memo)(({
  deleteTimelines,
  defaultPageSize,
  favoriteCount,
  hideActions = [],
  isLoading,
  itemIdToExpandedNotesRowMap,
  onAddTimelinesToFavorites,
  onDeleteSelected,
  onlyFavorites,
  onOpenTimeline,
  onQueryChange,
  onSelectionChange,
  onTableChange,
  onToggleOnlyFavorites,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  searchResults,
  selectedItems,
  sortDirection,
  sortField,
  timelineFilter,
  timelineType,
  templateTimelineFilter,
  title,
  totalSearchResultsCount
}) => {
  const actionsToShow = (0, _react.useMemo)(() => {
    const actions = ['createFrom', 'duplicate'];
    if (onDeleteSelected != null && deleteTimelines != null) {
      actions.push('delete');
    }
    return actions.filter(action => !hideActions.includes(action));
  }, [onDeleteSelected, deleteTimelines, hideActions]);
  const SearchRowContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: "search-row-content"
  }, !!templateTimelineFilter && templateTimelineFilter), [templateTimelineFilter]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(HeaderContainer, null, /*#__PURE__*/_react.default.createElement(_title_row.TitleRow, {
    "data-test-subj": "title-row",
    onAddTimelinesToFavorites: onAddTimelinesToFavorites,
    selectedTimelinesCount: selectedItems.length,
    title: title
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!timelineFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timelineFilter, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_search_row.SearchRow, {
    "data-test-subj": "search-row",
    onlyFavorites: onlyFavorites,
    onQueryChange: onQueryChange,
    onToggleOnlyFavorites: onToggleOnlyFavorites,
    query: "",
    timelineType: timelineType
  }, SearchRowContent), /*#__PURE__*/_react.default.createElement(_timelines_table.TimelinesTable, {
    actionTimelineToShow: actionsToShow,
    "data-test-subj": "timelines-table",
    deleteTimelines: deleteTimelines,
    defaultPageSize: defaultPageSize,
    loading: isLoading,
    itemIdToExpandedNotesRowMap: itemIdToExpandedNotesRowMap,
    onOpenTimeline: onOpenTimeline,
    onSelectionChange: onSelectionChange,
    onTableChange: onTableChange,
    onToggleShowNotes: onToggleShowNotes,
    pageIndex: pageIndex,
    pageSize: pageSize,
    searchResults: searchResults,
    showExtendedColumns: false,
    sortDirection: sortDirection,
    sortField: sortField,
    timelineType: timelineType,
    totalSearchResultsCount: totalSearchResultsCount
  }))));
});
exports.OpenTimelineModalBody = OpenTimelineModalBody;
OpenTimelineModalBody.displayName = 'OpenTimelineModalBody';