"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LazyAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * An accordion that doesn't render it's content unless it's expanded.
 * This component was created because `EuiAccordion`'s eager rendering of
 * accordion content was creating performance issues when used in repeating
 * content on the page.
 *
 * The current implementation actually renders the content *outside* of the
 * actual EuiAccordion when the accordion is expanded! It does this because
 * EuiAccordian applies a `translate` style to the content that causes
 * any draggable content (inside `EuiAccordian`) to have a `translate` style
 * that messes up rendering while the user drags it.
 *
 * TODO: animate the expansion and collapse of content rendered "below"
 * the real `EuiAccordion`.
 */
const LazyAccordion = /*#__PURE__*/_react.default.memo(({
  buttonContent,
  buttonContentClassName,
  extraAction,
  forceExpand,
  id,
  onCollapse,
  onExpand,
  paddingSize,
  renderExpandedContent
}) => {
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const onCollapsedClick = (0, _react.useCallback)(() => {
    setExpanded(true);
    if (onExpand != null) {
      onExpand();
    }
  }, [onExpand]);
  const onExpandedClick = (0, _react.useCallback)(() => {
    setExpanded(false);
    if (onCollapse != null) {
      onCollapse();
    }
  }, [onCollapse]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, forceExpand || expanded ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    buttonContent: buttonContent,
    buttonContentClassName: buttonContentClassName,
    "data-test-subj": "lazy-accordion-expanded",
    extraAction: extraAction,
    id: id,
    initialIsOpen: true,
    onClick: onExpandedClick,
    paddingSize: paddingSize
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), renderExpandedContent(expanded)) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    buttonContent: buttonContent,
    buttonContentClassName: buttonContentClassName,
    "data-test-subj": "lazy-accordion-placeholder",
    extraAction: extraAction,
    id: id,
    onClick: onCollapsedClick,
    paddingSize: paddingSize
  }));
});
exports.LazyAccordion = LazyAccordion;
LazyAccordion.displayName = 'LazyAccordion';