"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePaneStyles = exports.OverflowHiddenGlobalStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePaneStyles = () => {
  const EuiTheme = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = EuiTheme;
  return (0, _css.css)`
    // euiOverlayMask styles
    position: fixed;
    top: var(--euiFixedHeadersOffset, 0);
    left: 0;
    right: 0;
    bottom: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: ${(0, _eui.transparentize)(euiTheme.colors.ink, 0.5)};
    z-index: ${euiTheme.levels.flyout};

    ${_eui.euiCanAnimate} {
      animation: ${_eui.euiAnimFadeIn} ${euiTheme.animation.fast} ease-in;
    }

    &.timeline-wrapper--hidden {
      display: none;
    }

    .timeline-flyout {
      min-width: 150px;
      height: inherit;
      position: fixed;
      top: var(--euiFixedHeadersOffset, 0);
      right: 0;
      bottom: 0;
      left: 0;
      background: ${(0, _eui.euiBackgroundColor)(EuiTheme, 'plain')};
      ${_eui.euiCanAnimate} {
        animation: ${(0, _eui.euiAnimSlideInUp)(euiTheme.size.xxl)} ${euiTheme.animation.normal}
          cubic-bezier(0.39, 0.575, 0.565, 1);
      }

      .timeline-body {
        height: 100%;
        display: flex;
        flex-direction: column;
      }
    }

    &:not(.timeline-wrapper--full-screen) .timeline-flyout {
      margin: ${euiTheme.size.m};
      border-radius: ${euiTheme.border.radius.medium};

      .timeline-template-badge {
        border-radius: ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium} 0 0; // top corners only
      }
    }
  `;
};
exports.usePaneStyles = usePaneStyles;
const OverflowHiddenGlobalStyles = () => {
  return /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: 'body { overflow: hidden }'
  });
};
exports.OverflowHiddenGlobalStyles = OverflowHiddenGlobalStyles;