"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMPTY_RESOLVER = void 0;
exports.immerCase = immerCase;
exports.initialAnalyzerState = void 0;
exports.mockReducer = mockReducer;
var _immer = _interopRequireDefault(require("immer"));
var _scale_to_zoom = require("./camera/scale_to_zoom");
var _reducer = require("./reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_RESOLVER = {
  data: {
    currentRelatedEvent: {
      loading: false,
      data: null
    },
    tree: {},
    resolverComponentInstanceID: undefined,
    indices: [],
    detectedBounds: undefined
  },
  camera: {
    scalingFactor: (0, _scale_to_zoom.scaleToZoom)(1),
    // Defaulted to 1 to 1 scale
    rasterSize: [0, 0],
    translationNotCountingCurrentPanning: [0, 0],
    latestFocusedWorldCoordinates: null,
    animation: undefined,
    panning: undefined
  },
  ui: {
    ariaActiveDescendant: null,
    selectedNode: null
  }
};

/**
 * Helper function to support use of immer within action creators.
 * This allows reducers to be written in immer (direct mutation in appearance) over spread operators.
 * More information on immer: https://immerjs.github.io/immer/
 * @param actionCreator action creator
 * @param handler reducer written in immer
 * @returns reducer builder
 */
exports.EMPTY_RESOLVER = EMPTY_RESOLVER;
function immerCase(actionCreator, handler) {
  return reducer => reducer.case(actionCreator, (state, payload) => (0, _immer.default)(state, draft => handler(draft, payload)));
}
const initialAnalyzerState = {};
exports.initialAnalyzerState = initialAnalyzerState;
function mockReducer(id) {
  const testReducer = (state = {
    [id]: EMPTY_RESOLVER
  }, action) => (0, _reducer.analyzerReducer)(state, action);
  return testReducer;
}