"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zoomCurveRate = exports.unitsPerNudge = exports.panAnimationDuration = exports.nudgeAnimationDuration = exports.minimum = exports.maximum = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The minimum allowed value for the camera scale. This is the least scale that we will ever render something at.
 */
const minimum = 0.5;

/**
 * The maximum allowed value for the camera scale. This is greatest scale that we will ever render something at.
 */
exports.minimum = minimum;
const maximum = 2;

/**
 * The curve of the zoom function growth rate. The higher the scale factor is, the higher the zoom rate will be.
 */
exports.maximum = maximum;
const zoomCurveRate = 2;

/**
 * The size, in world units, of a 'nudge' as caused by clicking the up, right, down, or left panning buttons.
 */
exports.zoomCurveRate = zoomCurveRate;
const unitsPerNudge = 50;

/**
 * The duration a nudge animation lasts.
 */
exports.unitsPerNudge = unitsPerNudge;
const nudgeAnimationDuration = 300;

/**
 * The duration a panning animation lasts
 */
exports.nudgeAnimationDuration = nudgeAnimationDuration;
const panAnimationDuration = 1000;
exports.panAnimationDuration = panAnimationDuration;