"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewNetworkStats = exports.OverviewNetworkStats = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _stat_value = require("../stat_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOverviewNetworkStats = data => {
  var _data$auditbeatSocket, _data$filebeatCisco, _data$filebeatNetflow, _data$filebeatPanw, _data$filebeatSuricat, _data$filebeatZeek, _data$packetbeatDNS, _data$packetbeatFlow, _data$packetbeatTLS;
  return [{
    count: (_data$auditbeatSocket = data.auditbeatSocket) !== null && _data$auditbeatSocket !== void 0 ? _data$auditbeatSocket : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatSocketTitle",
      defaultMessage: "Socket"
    }),
    id: 'auditbeatSocket'
  }, {
    count: (_data$filebeatCisco = data.filebeatCisco) !== null && _data$filebeatCisco !== void 0 ? _data$filebeatCisco : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatCiscoTitle",
      defaultMessage: "Cisco"
    }),
    id: 'filebeatCisco'
  }, {
    count: (_data$filebeatNetflow = data.filebeatNetflow) !== null && _data$filebeatNetflow !== void 0 ? _data$filebeatNetflow : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatNetflowTitle",
      defaultMessage: "Netflow"
    }),
    id: 'filebeatNetflow'
  }, {
    count: (_data$filebeatPanw = data.filebeatPanw) !== null && _data$filebeatPanw !== void 0 ? _data$filebeatPanw : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatPanwTitle",
      defaultMessage: "Palo Alto Networks"
    }),
    id: 'filebeatPanw'
  }, {
    count: (_data$filebeatSuricat = data.filebeatSuricata) !== null && _data$filebeatSuricat !== void 0 ? _data$filebeatSuricat : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.fileBeatSuricataTitle",
      defaultMessage: "Suricata"
    }),
    id: 'filebeatSuricata'
  }, {
    count: (_data$filebeatZeek = data.filebeatZeek) !== null && _data$filebeatZeek !== void 0 ? _data$filebeatZeek : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.fileBeatZeekTitle",
      defaultMessage: "Zeek"
    }),
    id: 'filebeatZeek'
  }, {
    count: (_data$packetbeatDNS = data.packetbeatDNS) !== null && _data$packetbeatDNS !== void 0 ? _data$packetbeatDNS : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.packetBeatDnsTitle",
      defaultMessage: "DNS"
    }),
    id: 'packetbeatDNS'
  }, {
    count: (_data$packetbeatFlow = data.packetbeatFlow) !== null && _data$packetbeatFlow !== void 0 ? _data$packetbeatFlow : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.packetBeatFlowTitle",
      defaultMessage: "Flow"
    }),
    id: 'packetbeatFlow'
  }, {
    count: (_data$packetbeatTLS = data.packetbeatTLS) !== null && _data$packetbeatTLS !== void 0 ? _data$packetbeatTLS : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.packetbeatTLSTitle",
      defaultMessage: "TLS"
    }),
    id: 'packetbeatTLS'
  }];
};
exports.getOverviewNetworkStats = getOverviewNetworkStats;
const networkStatGroups = [{
  groupId: 'auditbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkStatGroupAuditbeat",
    defaultMessage: "Auditbeat"
  }),
  statIds: ['auditbeatSocket']
}, {
  groupId: 'filebeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkStatGroupFilebeat",
    defaultMessage: "Filebeat"
  }),
  statIds: ['filebeatCisco', 'filebeatNetflow', 'filebeatPanw', 'filebeatSuricata', 'filebeatZeek']
}, {
  groupId: 'packetbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkStatGroupPacketbeat",
    defaultMessage: "Packetbeat"
  }),
  statIds: ['packetbeatDNS', 'packetbeatFlow', 'packetbeatTLS']
}];
const NetworkStatsContainer = _styledComponents.default.div`
  .accordion-button {
    width: 100%;
  }
`;
const MoveItLeftTitle = _styledComponents.default.div`
  margin-left: 24px;
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    max-width: 40px;
  }
`;
const MoveItLeft = _styledComponents.default.div`
  margin-left: 24px;
`;
const NoMarginTopFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media only screen and (max-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    margin-top: -10px !important;
  }
`;
const AccordionContent = _styledComponents.default.div`
  padding-top: 8px;
`;
const OverviewNetworkStatsComponent = ({
  data,
  loading
}) => {
  const allNetworkStats = getOverviewNetworkStats(data);
  const allNetworkStatsCount = allNetworkStats.reduce((total, stat) => total + stat.count, 0);
  return /*#__PURE__*/_react.default.createElement(NetworkStatsContainer, {
    "data-test-subj": "overview-network-stats"
  }, networkStatGroups.map((statGroup, i) => {
    const statsForGroup = allNetworkStats.filter(s => statGroup.statIds.includes(s.id));
    const statsForGroupCount = statsForGroup.reduce((total, stat) => total + stat.count, 0);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: statGroup.groupId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `network-stat-accordion-group${statGroup.groupId}`,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": `network-stat-group-${statGroup.groupId}`,
        justifyContent: "spaceBetween",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, statGroup.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
        count: statsForGroupCount,
        isGroupStat: true,
        isLoading: loading,
        max: allNetworkStatsCount
      }))),
      buttonContentClassName: "accordion-button"
    }, /*#__PURE__*/_react.default.createElement(AccordionContent, null, statsForGroup.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: stat.id,
      gutterSize: "s",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(MoveItLeftTitle, null, stat.title))), /*#__PURE__*/_react.default.createElement(NoMarginTopFlexItem, {
      "data-test-subj": `network-stat-${stat.id}`,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(MoveItLeft, null, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
      count: stat.count,
      isGroupStat: false,
      isLoading: loading,
      max: statsForGroupCount
    }))))))));
  }));
};
const OverviewNetworkStats = /*#__PURE__*/_react.default.memo(OverviewNetworkStatsComponent);
exports.OverviewNetworkStats = OverviewNetworkStats;