"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelPanelView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _link_panel = require("../link_panel");
var _shorten_count_into_string = require("../../../common/utils/shorten_count_into_string");
var _link = require("../link_panel/link");
var _use_ti_data_sources = require("../../containers/overview_cti_links/use_ti_data_sources");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  name: 'Name',
  field: 'title',
  sortable: true,
  truncateText: true,
  width: '100%'
}, {
  name: 'Indicator',
  field: 'count',
  render: _shorten_count_into_string.shortenCountIntoString,
  sortable: true,
  truncateText: true,
  width: '70px',
  align: 'right'
}, {
  name: '',
  field: 'path',
  truncateText: true,
  width: '80px',
  render: path => /*#__PURE__*/_react.default.createElement(_link.Link, {
    path: path,
    copy: i18n.LINK_COPY
  })
}];
const ThreatIntelPanelView = ({
  isInspectEnabled = true,
  listItems,
  splitPanel,
  totalCount = 0
}) => {
  return /*#__PURE__*/_react.default.createElement(_link_panel.LinkPanel, {
    columns,
    dataTestSubj: 'cti-dashboard-links',
    inspectQueryId: isInspectEnabled ? _use_ti_data_sources.ID : undefined,
    listItems,
    panelTitle: i18n.PANEL_TITLE,
    splitPanel,
    subtitle: (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "cti-total-event-count",
      defaultMessage: "Showing: {totalCount} {totalCount, plural, one {indicator} other {indicators}}",
      id: "xpack.securitySolution.overview.ctiDashboardSubtitle",
      values: {
        totalCount
      }
    }), [totalCount]),
    button: (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      "data-test-subj": "cti-view-indicators",
      deepLinkId: _constants.SecurityPageName.threatIntelligence
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.threatIndicatorsAction",
      defaultMessage: "View indicators"
    })), [])
  });
};
exports.ThreatIntelPanelView = ThreatIntelPanelView;