"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskScoreColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _model = require("../../../../explore/users/store/model");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var _model2 = require("../../../../explore/hosts/store/model");
var _common = require("../../../../explore/components/risk_score/severity/common");
var _constants = require("../../../../explore/components/risk_score/constants");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_number = require("../../../../common/components/formatted_number");
var _cell_actions = require("../../../../common/components/cell_actions");
var _formatted_date = require("../../../../common/components/formatted_date");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledCellActions = (0, _styledComponents.default)(_cell_actions.SecurityCellActions)`
  padding-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const getRiskScoreColumns = (riskEntity, openEntityOnAlertsPage) => [{
  field: riskEntity === _search_strategy.RiskScoreEntity.host ? 'host.name' : 'user.name',
  name: i18n.ENTITY_NAME(riskEntity),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  className: 'inline-actions-table-cell',
  render: entityName => {
    if (entityName != null && entityName.length > 0) {
      return riskEntity === _search_strategy.RiskScoreEntity.host ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: entityName,
        hostTab: _model2.HostsTableType.risk
      }), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
        data: {
          value: entityName,
          field: 'host.name'
        },
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        mode: _cell_actions.CellActionsMode.INLINE,
        visibleCellActions: 2,
        disabledActionTypes: [_cell_actions.SecurityCellActionType.FILTER, _cell_actions.SecurityCellActionType.SHOW_TOP_N],
        metadata: {
          telemetry: _constants.CELL_ACTIONS_TELEMETRY
        }
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
        userName: entityName,
        userTab: _model.UsersTableType.risk
      }), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
        data: {
          value: entityName,
          field: 'user.name'
        },
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        mode: _cell_actions.CellActionsMode.INLINE,
        disabledActionTypes: [_cell_actions.SecurityCellActionType.FILTER, _cell_actions.SecurityCellActionType.SHOW_TOP_N]
      }));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.timestamp,
  name: i18n.LAST_UPDATED,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  width: '20%',
  render: lastSeen => {
    if (lastSeen != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastSeen
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: riskEntity === _search_strategy.RiskScoreEntity.host ? _search_strategy.RiskScoreFields.hostRiskScore : _search_strategy.RiskScoreFields.userRiskScore,
  width: '15%',
  name: i18n.RISK_SCORE_TITLE(riskEntity),
  truncateText: true,
  mobileOptions: {
    show: true
  },
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "risk-score-truncate",
        title: `${riskScore}`
      }, Math.round(riskScore));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: riskEntity === _search_strategy.RiskScoreEntity.host ? _search_strategy.RiskScoreFields.hostRisk : _search_strategy.RiskScoreFields.userRisk,
  width: '25%',
  name: i18n.ENTITY_RISK_LEVEL(riskEntity),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: risk => {
    if (risk != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        severity: risk
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.alertsCount,
  width: '10%',
  name: i18n.ALERTS,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  className: 'inline-actions-table-cell',
  render: (alertCount, risk) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "risk-score-alerts",
    disabled: alertCount === 0,
    onClick: () => openEntityOnAlertsPage(riskEntity === _search_strategy.RiskScoreEntity.host ? risk.host.name : risk.user.name)
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: alertCount
  })), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
    data: {
      value: riskEntity === _search_strategy.RiskScoreEntity.host ? risk.host.name : risk.user.name,
      field: riskEntity === _search_strategy.RiskScoreEntity.host ? 'host.name' : 'user.name'
    },
    mode: _cell_actions.CellActionsMode.INLINE,
    triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }))
}];
exports.getRiskScoreColumns = getRiskScoreColumns;