"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesTabLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _links = require("../../../../../common/components/links");
var _types = require("../../../../../app/types");
var _store = require("../../../../../explore/users/store");
var _store2 = require("../../../../../explore/hosts/store");
var _model = require("../../../../../explore/hosts/store/model");
var _model2 = require("../../../../../explore/users/store/model");
var _use_anomalies_search = require("../../../../../common/components/ml/anomaly/use_anomalies_search");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomaliesTabLink = ({
  count,
  jobId,
  entity
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const deepLinkId = entity === _use_anomalies_search.AnomalyEntity.User ? _types.SecurityPageName.usersAnomalies : _types.SecurityPageName.hostsAnomalies;
  const onClick = (0, _react.useCallback)(() => {
    if (!jobId) return;
    if (entity === _use_anomalies_search.AnomalyEntity.User) {
      dispatch(_store.usersActions.updateUsersAnomaliesJobIdFilter({
        jobIds: [jobId],
        usersType: _model2.UsersType.page
      }));
      dispatch(_store.usersActions.updateUsersAnomaliesInterval({
        interval: 'second',
        usersType: _model2.UsersType.page
      }));
    } else {
      dispatch(_store2.hostsActions.updateHostsAnomaliesJobIdFilter({
        jobIds: [jobId],
        hostsType: _model.HostsType.page
      }));
      dispatch(_store2.hostsActions.updateHostsAnomaliesInterval({
        interval: 'second',
        hostsType: _model.HostsType.page
      }));
    }
  }, [jobId, dispatch, entity]);
  return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    onClick: onClick,
    deepLinkId: deepLinkId
  }, count);
};
exports.AnomaliesTabLink = AnomaliesTabLink;