"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleAlertsItems = exports.TIMESTAMP = exports.KIBANA_RULE_NAME = exports.KIBANA_RULE_ID = exports.KIBANA_ALERT_SEVERITY = void 0;
var _react = require("react");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_query = require("../../../../detections/containers/detection_engine/alerts/use_query");
var _constants = require("../../../../detections/containers/detection_engine/alerts/constants");
var _manage_query = require("../../../../common/components/page/manage_query");
var _ecs_safety_helpers = require("../../../../../common/endpoint/models/ecs_safety_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Formatted item result

// Raw aggregation response

const KIBANA_RULE_NAME = 'kibana.alert.rule.name';
exports.KIBANA_RULE_NAME = KIBANA_RULE_NAME;
const KIBANA_RULE_ID = 'kibana.alert.rule.uuid';
exports.KIBANA_RULE_ID = KIBANA_RULE_ID;
const KIBANA_ALERT_SEVERITY = 'kibana.alert.severity';
exports.KIBANA_ALERT_SEVERITY = KIBANA_ALERT_SEVERITY;
const TIMESTAMP = '@timestamp';
exports.TIMESTAMP = TIMESTAMP;
const getSeverityRuleAlertsQuery = ({
  from,
  to,
  filterQuery
}) => ({
  _source: false,
  fields: [KIBANA_RULE_NAME, KIBANA_RULE_ID, KIBANA_ALERT_SEVERITY, TIMESTAMP],
  size: 0,
  query: {
    bool: {
      filter: [{
        term: {
          'kibana.alert.workflow_status': 'open'
        }
      }, {
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      }, ...(filterQuery ? [filterQuery] : [])]
    }
  },
  aggs: {
    alertsByRule: {
      terms: {
        // top 4 rules sorted by severity counters
        field: 'kibana.alert.rule.name',
        size: 4,
        order: [{
          critical: 'desc'
        }, {
          high: 'desc'
        }, {
          medium: 'desc'
        }, {
          low: 'desc'
        }]
      },
      aggs: {
        // severity aggregations for sorting
        critical: {
          filter: {
            term: {
              'kibana.alert.severity': 'critical'
            }
          }
        },
        high: {
          filter: {
            term: {
              'kibana.alert.severity': 'high'
            }
          }
        },
        medium: {
          filter: {
            term: {
              'kibana.alert.severity': 'medium'
            }
          }
        },
        low: {
          filter: {
            term: {
              'kibana.alert.severity': 'low'
            }
          }
        },
        // get the newest alert to extract timestamp and rule name
        lastRuleAlert: {
          top_hits: {
            size: 1,
            sort: {
              '@timestamp': 'desc'
            }
          }
        }
      }
    }
  }
});
const getRuleAlertsItemsFromAggs = aggregations => {
  var _aggregations$alertsB;
  const buckets = (_aggregations$alertsB = aggregations === null || aggregations === void 0 ? void 0 : aggregations.alertsByRule.buckets) !== null && _aggregations$alertsB !== void 0 ? _aggregations$alertsB : [];
  return buckets.map(bucket => {
    var _firstNonNullValue, _firstNonNullValue2, _firstNonNullValue3, _firstNonNullValue4;
    const lastAlert = bucket.lastRuleAlert.hits.hits[0].fields;
    return {
      id: (_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)(lastAlert[KIBANA_RULE_ID])) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '',
      alert_count: bucket.lastRuleAlert.hits.total.value,
      name: (_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)(lastAlert[KIBANA_RULE_NAME])) !== null && _firstNonNullValue2 !== void 0 ? _firstNonNullValue2 : '',
      last_alert_at: (_firstNonNullValue3 = (0, _ecs_safety_helpers.firstNonNullValue)(lastAlert[TIMESTAMP])) !== null && _firstNonNullValue3 !== void 0 ? _firstNonNullValue3 : '',
      severity: (_firstNonNullValue4 = (0, _ecs_safety_helpers.firstNonNullValue)(lastAlert[KIBANA_ALERT_SEVERITY])) !== null && _firstNonNullValue4 !== void 0 ? _firstNonNullValue4 : 'low'
    };
  });
};
const useRuleAlertsItems = ({
  queryId,
  signalIndexName,
  skip = false,
  filterQuery
}) => {
  const [items, setItems] = (0, _react.useState)([]);
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const {
    to,
    from,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const query = (0, _react.useMemo)(() => getSeverityRuleAlertsQuery({
    from,
    to,
    filterQuery
  }), [filterQuery, from, to]);
  const {
    loading: isLoading,
    data,
    setQuery: setAlertsQuery,
    response,
    request,
    refetch: refetchQuery
  } = (0, _use_query.useQueryAlerts)({
    query,
    indexName: signalIndexName,
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.BY_SEVERITY
  });
  (0, _react.useEffect)(() => {
    setAlertsQuery(query);
  }, [setAlertsQuery, query]);
  (0, _react.useEffect)(() => {
    if (data == null) {
      setItems([]);
    } else {
      setItems(getRuleAlertsItemsFromAggs(data.aggregations));
    }
    setUpdatedAt(Date.now());
  }, [data]);
  const refetch = (0, _react.useCallback)(() => {
    if (!skip && refetchQuery) {
      refetchQuery();
    }
  }, [skip, refetchQuery]);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: {
      dsl: [request],
      response: [response]
    },
    refetch,
    setQuery,
    queryId,
    loading: isLoading
  });
  return {
    items,
    isLoading,
    updatedAt
  };
};
exports.useRuleAlertsItems = useRuleAlertsItems;