"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreInfoTooltip = exports.RiskScoreDocTooltip = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_score_doc_link = require("../../explore/components/risk_score/risk_score_onboarding/risk_score_doc_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreInfoTooltip = ({
  toolTipContent,
  toolTipTitle,
  width = 270
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      size: "xs",
      iconSize: "m",
      iconType: "iInCircle",
      "aria-label": i18n.INFORMATION_ARIA_LABEL,
      onClick: onClick
    })
  }, toolTipTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, toolTipTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      width: `${width}px`
    }
  }, toolTipContent));
};
exports.RiskScoreInfoTooltip = RiskScoreInfoTooltip;
const RiskScoreDocTooltip = ({
  riskScoreEntity
}) => /*#__PURE__*/_react.default.createElement(RiskScoreInfoTooltip, {
  toolTipContent: /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
    riskScoreEntity: riskScoreEntity
  }),
  width: 200 // Magic number to match the width of the doc link
});
exports.RiskScoreDocTooltip = RiskScoreDocTooltip;