"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustedAppsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _validations = require("../../../../../../common/endpoint/service/artifacts/validations");
var _artifacts = require("../../../../../../common/endpoint/service/artifacts");
var _type_guards = require("../../state/type_guards");
var _translations = require("../translations");
var _translations2 = require("../../../../common/translations");
var _logical_condition = require("./logical_condition");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _use_license = require("../../../../../common/hooks/use_license");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _constants = require("../../../../../../common/endpoint/service/artifacts/constants");
var _utils = require("../../../../components/effected_policy_select/utils");
var _artifacts_docs_link = require("./artifacts_docs_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addResultToValidation = (validation, field, type, resultValue) => {
  if (!validation.result[field]) {
    validation.result[field] = {
      isInvalid: false,
      errors: [],
      warnings: []
    };
  }
  const errorMarkup = type === 'warnings' ? /*#__PURE__*/_react.default.createElement("div", null, resultValue) : resultValue;
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  validation.result[field][type].push(errorMarkup);
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  validation.result[field].isInvalid = true;
};
const validateValues = values => {
  var _ref, _values$os_types;
  let isValid = true;
  const validation = {
    isValid,
    result: {}
  };

  // Name field
  if (!values.name.trim()) {
    isValid = false;
    addResultToValidation(validation, 'name', 'errors', _translations.INPUT_ERRORS.name);
  }
  if (!values.os_types) {
    isValid = false;
    addResultToValidation(validation, 'os', 'errors', _translations.INPUT_ERRORS.os);
  }
  const os = (_ref = ((_values$os_types = values.os_types) !== null && _values$os_types !== void 0 ? _values$os_types : [])[0]) !== null && _ref !== void 0 ? _ref : _securitysolutionUtils.OperatingSystem.WINDOWS;
  if (!values.entries.length) {
    isValid = false;
    addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.field);
  } else {
    const duplicated = (0, _validations.getDuplicateFields)(values.entries);
    if (duplicated.length) {
      isValid = false;
      duplicated.forEach(field => {
        addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.noDuplicateField(field));
      });
    }
    values.entries.forEach((entry, index) => {
      const isValidPathEntry = (0, _securitysolutionUtils.isPathValid)({
        os,
        field: entry.field,
        type: entry.type,
        value: entry.value
      });
      if (!entry.field || !entry.value.trim()) {
        isValid = false;
        addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.mustHaveValue(index));
      } else if (entry.field === _securitysolutionUtils.ConditionEntryField.HASH && !(0, _validations.isValidHash)(entry.value)) {
        isValid = false;
        addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.invalidHash(index));
      } else if (!isValidPathEntry) {
        addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.pathWarning(index));
      } else if (isValidPathEntry && !(0, _securitysolutionUtils.hasSimpleExecutableName)({
        os,
        value: entry.value,
        type: entry.type
      })) {
        addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.wildcardPathWarning(index));
      }
    });
  }
  validation.isValid = isValid;
  return validation;
};
const defaultConditionEntry = () => ({
  field: _securitysolutionUtils.ConditionEntryField.HASH,
  operator: 'included',
  type: 'match',
  value: ''
});
const TrustedAppsForm = /*#__PURE__*/(0, _react.memo)(({
  item,
  policies,
  policiesIsLoading,
  onChange,
  mode
}) => {
  var _validationResult$res, _validationResult$res2, _validationResult$res3, _validationResult$res4, _validationResult$res5, _validationResult$res6, _validationResult$res7;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)('trustedApps-form');
  const [visited, setVisited] = (0, _react.useState)({});
  const [selectedPolicies, setSelectedPolicies] = (0, _react.useState)([]);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isGlobal = (0, _react.useMemo)(() => (0, _artifacts.isArtifactGlobal)(item), [item]);
  const [wasByPolicy, setWasByPolicy] = (0, _react.useState)(!(0, _utils.isGlobalPolicyEffected)(item.tags));
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!hasFormChanged && item.tags) {
      setWasByPolicy(!(0, _utils.isGlobalPolicyEffected)(item.tags));
    }
  }, [item.tags, hasFormChanged]);

  // select policies if editing
  (0, _react.useEffect)(() => {
    if (hasFormChanged) {
      return;
    }
    const policyIds = item.tags ? (0, _artifacts.getPolicyIdsFromArtifact)({
      tags: item.tags
    }) : [];
    if (!policyIds.length) {
      return;
    }
    const policiesData = policies.filter(policy => policyIds.includes(policy.id));
    setSelectedPolicies(policiesData);
  }, [hasFormChanged, item, policies]);
  const showAssignmentSection = (0, _react.useMemo)(() => {
    return isPlatinumPlus || mode === 'edit' && (!isGlobal || wasByPolicy && isGlobal && hasFormChanged);
  }, [mode, isGlobal, hasFormChanged, isPlatinumPlus, wasByPolicy]);
  const [validationResult, setValidationResult] = (0, _react.useState)(() => validateValues(item));
  const processChanged = (0, _react.useCallback)(updatedFormValues => {
    const updatedValidationResult = validateValues(updatedFormValues);
    setValidationResult(updatedValidationResult);
    onChange({
      item: updatedFormValues,
      isValid: updatedValidationResult.isValid
    });
  }, [onChange]);
  const handleOnPolicyChange = (0, _react.useCallback)(change => {
    const tags = change.isGlobal ? [_constants.GLOBAL_ARTIFACT_TAG] : change.selected.map(policy => `${_constants.BY_POLICY_ARTIFACT_TAG_PREFIX}${policy.id}`);
    const nextItem = {
      ...item,
      tags
    };
    // Preserve old selected policies when switching to global
    if (!change.isGlobal) {
      setSelectedPolicies(change.selected);
    }
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleOnNameOrDescriptionChange = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      [event.target.name]: event.target.value
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleOnNameBlur = (0, _react.useCallback)(({
    target: {
      name
    }
  }) => {
    processChanged(item);
    setVisited(prevVisited => ({
      ...prevVisited,
      [name]: true
    }));
  }, [item, processChanged]);
  const osOptions = (0, _react.useMemo)(() => [_securitysolutionUtils.OperatingSystem.LINUX, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.WINDOWS].map(os => ({
    value: os,
    inputDisplay: _translations2.OS_TITLES[os]
  })), []);
  const handleOnOsChange = (0, _react.useCallback)(os => {
    setVisited(prevVisited => {
      return {
        ...prevVisited,
        os: true
      };
    });
    const nextItem = {
      ...item,
      os_types: [os],
      entries: []
    };
    if (os !== _securitysolutionUtils.OperatingSystem.WINDOWS) {
      const macOsLinuxConditionEntry = item.entries.filter(entry => (0, _type_guards.isMacosLinuxTrustedAppCondition)(entry));
      nextItem.entries.push(...macOsLinuxConditionEntry);
      if (item.entries.length === 0) {
        nextItem.entries.push(defaultConditionEntry());
      }
    } else {
      nextItem.entries.push(...item.entries);
    }
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleConditionBuilderOnVisited = (0, _react.useCallback)(() => {
    setVisited(prevState => {
      return {
        ...prevState,
        entries: true
      };
    });
  }, []);
  const handleEntryChange = (0, _react.useCallback)((newEntry, oldEntry) => {
    const nextItem = {
      ...item,
      entries: item.entries.map(e => {
        if (e === oldEntry) {
          return newEntry;
        }
        return e;
      })
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleEntryRemove = (0, _react.useCallback)(entry => {
    const nextItem = {
      ...item,
      entries: item.entries.filter(e => e !== entry)
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleAndClick = (0, _react.useCallback)(() => {
    var _ref2, _item$os_types;
    const nextItem = {
      ...item,
      entries: []
    };
    const os = (_ref2 = ((_item$os_types = item.os_types) !== null && _item$os_types !== void 0 ? _item$os_types : [])[0]) !== null && _ref2 !== void 0 ? _ref2 : _securitysolutionUtils.OperatingSystem.WINDOWS;
    if (os === _securitysolutionUtils.OperatingSystem.WINDOWS) {
      nextItem.entries = [...item.entries, defaultConditionEntry()].filter(entry => (0, _type_guards.isWindowsTrustedAppCondition)(entry));
    } else {
      nextItem.entries = [...item.entries.filter(entry => (0, _type_guards.isMacosLinuxTrustedAppCondition)(entry)), defaultConditionEntry()];
    }
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const selectedOs = (0, _react.useMemo)(() => {
    var _item$os_types2;
    if (!(item !== null && item !== void 0 && (_item$os_types2 = item.os_types) !== null && _item$os_types2 !== void 0 && _item$os_types2.length)) {
      return _securitysolutionUtils.OperatingSystem.WINDOWS;
    }
    return item.os_types[0];
  }, [item === null || item === void 0 ? void 0 : item.os_types]);
  const trustedApp = (0, _react.useMemo)(() => {
    const ta = item;
    ta.entries = item.entries.length ? item.entries : [defaultConditionEntry()];
    return ta;
  }, [item]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    "data-test-subj": getTestId('')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.DETAILS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), mode === 'create' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('about')
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.DETAILS_HEADER_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_artifacts_docs_link.TrustedAppsArtifactsDocsLink, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.NAME_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('nameRow'),
    isInvalid: visited.name && ((_validationResult$res = validationResult.result.name) === null || _validationResult$res === void 0 ? void 0 : _validationResult$res.isInvalid),
    error: (_validationResult$res2 = validationResult.result.name) === null || _validationResult$res2 === void 0 ? void 0 : _validationResult$res2.errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    value: item.name,
    onChange: handleOnNameOrDescriptionChange,
    onBlur: handleOnNameBlur,
    fullWidth: true,
    required: visited.name,
    maxLength: 256,
    "data-test-subj": getTestId('nameTextField')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.DESCRIPTION_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('descriptionRow')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: item.description,
    onChange: handleOnNameOrDescriptionChange,
    fullWidth: true,
    compressed: true,
    maxLength: 256,
    "data-test-subj": getTestId('descriptionField')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.CONDITIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _translations.CONDITIONS_HEADER_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.SELECT_OS_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('OsRow'),
    isInvalid: (visited === null || visited === void 0 ? void 0 : visited.os) && ((_validationResult$res3 = validationResult.result.os) === null || _validationResult$res3 === void 0 ? void 0 : _validationResult$res3.isInvalid),
    error: (_validationResult$res4 = validationResult.result.os) === null || _validationResult$res4 === void 0 ? void 0 : _validationResult$res4.errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "os",
    options: osOptions,
    valueOfSelected: selectedOs,
    onChange: handleOnOsChange,
    fullWidth: true,
    "data-test-subj": getTestId('osSelectField')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": getTestId('conditionsRow'),
    isInvalid: visited.entries && ((_validationResult$res5 = validationResult.result.entries) === null || _validationResult$res5 === void 0 ? void 0 : _validationResult$res5.isInvalid),
    error: (_validationResult$res6 = validationResult.result.entries) === null || _validationResult$res6 === void 0 ? void 0 : _validationResult$res6.errors,
    helpText: (_validationResult$res7 = validationResult.result.entries) === null || _validationResult$res7 === void 0 ? void 0 : _validationResult$res7.warnings
  }, /*#__PURE__*/_react.default.createElement(_logical_condition.LogicalConditionBuilder, {
    entries: trustedApp.entries,
    os: selectedOs,
    onAndClicked: handleAndClick,
    onEntryRemove: handleEntryRemove,
    onEntryChange: handleEntryChange,
    onVisited: handleConditionBuilderOnVisited,
    "data-test-subj": getTestId('conditionsBuilder')
  })), showAssignmentSection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": getTestId('policySelection')
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    isGlobal: isGlobal,
    isPlatinumPlus: isPlatinumPlus,
    selected: selectedPolicies,
    options: policies,
    onChange: handleOnPolicyChange,
    isLoading: policiesIsLoading,
    description: _translations.POLICY_SELECT_DESCRIPTION,
    "data-test-subj": getTestId('effectedPolicies')
  }))) : null);
});
exports.TrustedAppsForm = TrustedAppsForm;
TrustedAppsForm.displayName = 'TrustedAppsForm';