"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionUpdatesBottomBar = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_navigate_to_app_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _common = require("../../../../../../../common");
var _routing = require("../../../../../common/routing");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProtectionUpdatesBottomBar = /*#__PURE__*/_react.default.memo(({
  isUpdating,
  onSave,
  saveButtonDisabled
}) => {
  const {
    state: locationRouteState
  } = (0, _reactRouterDom.useLocation)();
  const [routeState, setRouteState] = (0, _react.useState)();
  const routingOnCancelNavigateTo = routeState === null || routeState === void 0 ? void 0 : routeState.onCancelNavigateTo;
  (0, _react.useEffect)(() => {
    if (!routeState && locationRouteState) {
      setRouteState(locationRouteState);
    }
  }, [locationRouteState, routeState]);
  const navigateToAppArguments = (0, _react.useMemo)(() => {
    if (routingOnCancelNavigateTo) {
      return routingOnCancelNavigateTo;
    }
    return [_common.APP_UI_ID, {
      path: (0, _routing.getPoliciesPath)()
    }];
  }, [routingOnCancelNavigateTo]);
  const handleCancelOnClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(...navigateToAppArguments);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.BottomBar, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: handleCancelOnClick,
    "data-test-subj": "protectionUpdatesCancelButton",
    disabled: isUpdating
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.protectionUpdates.cancel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: saveButtonDisabled,
    iconType: "save",
    "data-test-subj": "protectionUpdatesSaveButton",
    onClick: onSave,
    isLoading: isUpdating
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.protectionUpdates.save",
    defaultMessage: "Save"
  })))));
});
exports.ProtectionUpdatesBottomBar = ProtectionUpdatesBottomBar;
ProtectionUpdatesBottomBar.displayName = 'ProtectionUpdatesBottomBar';