"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmUpdate = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmUpdate = /*#__PURE__*/_react.default.memo(({
  endpointCount,
  onCancel,
  onConfirm
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "policyDetailsConfirmModal",
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.title', {
      defaultMessage: 'Save and deploy changes'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.confirmButtonTitle', {
      defaultMessage: 'Save and deploy changes'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.cancelButtonTitle', {
      defaultMessage: 'Cancel'
    })
  }, endpointCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "policyDetailsWarningCallout",
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.warningTitle', {
      defaultMessage: 'This action will update {endpointCount, plural, one {# endpoint} other {# endpoints}}',
      values: {
        endpointCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.updateConfirm.warningMessage",
    defaultMessage: "Saving these changes will apply updates to all endpoints assigned to this agent policy."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.updateConfirm.message",
    defaultMessage: "This action cannot be undone. Are you sure you wish to continue?"
  })));
});
exports.ConfirmUpdate = ConfirmUpdate;
ConfirmUpdate.displayName = 'ConfirmUpdate';