"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedDetectionRulesCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _kibana = require("../../../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RelatedDetectionRulesCallout = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    docLinks: {
      links: {
        securitySolution
      }
    }
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    "data-test-subj": getTestId()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.detectionRulesDocsMessage",
    defaultMessage: "The Endpoint Security detection rule is enabled automatically with Elastic Defend. This rule must remain enabled to receive Endpoint alerts. {detectionRulesDocsLink}.",
    values: {
      detectionRulesDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": getTestId('link'),
        target: "_blank",
        href: `${securitySolution.detectionEngineOverview}`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.details.detectionRulesMessageDocsLink",
        defaultMessage: "Learn More"
      }))
    }
  }));
});
exports.RelatedDetectionRulesCallout = RelatedDetectionRulesCallout;
RelatedDetectionRulesCallout.displayName = 'RelatedDetectionRulesCallout';