"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SWITCH_ENABLED_LABEL = exports.SWITCH_DISABLED_LABEL = exports.LOCKED_CARD_ATTACK_SURFACE_REDUCTION = exports.AttackSurfaceReductionCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _use_license = require("../../../../../../../common/hooks/use_license");
var _setting_locked_card = require("../setting_locked_card");
var _setting_card = require("../setting_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACK_SURFACE_OS_LIST = [_securitysolutionUtils.OperatingSystem.WINDOWS];
const LOCKED_CARD_ATTACK_SURFACE_REDUCTION = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.attack_surface_reduction', {
  defaultMessage: 'Attack Surface Reduction'
});
exports.LOCKED_CARD_ATTACK_SURFACE_REDUCTION = LOCKED_CARD_ATTACK_SURFACE_REDUCTION;
const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.attackSurfaceReduction.type', {
  defaultMessage: 'Attack surface reduction'
});
const SWITCH_ENABLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.credentialHardening.toggleEnabled', {
  defaultMessage: 'Credential hardening enabled'
});
exports.SWITCH_ENABLED_LABEL = SWITCH_ENABLED_LABEL;
const SWITCH_DISABLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.credentialHardening.toggleDisabled', {
  defaultMessage: 'Credential hardening disabled'
});
exports.SWITCH_DISABLED_LABEL = SWITCH_DISABLED_LABEL;
const AttackSurfaceReductionCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const isChecked = policy.windows.attack_surface_reduction.credential_hardening.enabled;
  const isEditMode = mode === 'edit';
  const label = isChecked ? SWITCH_ENABLED_LABEL : SWITCH_DISABLED_LABEL;
  const handleSwitchChange = (0, _react.useCallback)(event => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    updatedPolicy.windows.attack_surface_reduction.credential_hardening.enabled = event.target.checked;
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [onChange, policy]);
  if (!isProtectionsAllowed) {
    return null;
  }
  if (!isPlatinumPlus) {
    return /*#__PURE__*/_react.default.createElement(_setting_locked_card.SettingLockedCard, {
      title: LOCKED_CARD_ATTACK_SURFACE_REDUCTION,
      "data-test-subj": getTestId('locked')
    });
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: CARD_TITLE,
    supportedOss: ATTACK_SURFACE_OS_LIST,
    dataTestSubj: getTestId()
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: label,
    checked: isChecked,
    onChange: handleSwitchChange,
    "data-test-subj": getTestId('enableDisableSwitch')
  }) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": getTestId('valueLabel')
  }, label));
});
exports.AttackSurfaceReductionCard = AttackSurfaceReductionCard;
AttackSurfaceReductionCard.displayName = 'AttackSurfaceReductionCard';