"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REGISTERED_LABEL = exports.NOT_REGISTERED_LABEL = exports.AntivirusRegistrationCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _setting_card = require("../setting_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.type', {
  defaultMessage: 'Register as antivirus'
});
const DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.explanation', {
  defaultMessage: 'Toggle on to register Elastic as an official Antivirus solution for Windows OS. ' + 'This will also disable Windows Defender.'
});
const REGISTERED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.type', {
  defaultMessage: 'Register as antivirus'
});
exports.REGISTERED_LABEL = REGISTERED_LABEL;
const NOT_REGISTERED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.notRegisteredLabel', {
  defaultMessage: 'Do not register as antivirus'
});
exports.NOT_REGISTERED_LABEL = NOT_REGISTERED_LABEL;
const AntivirusRegistrationCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const isChecked = policy.windows.antivirus_registration.enabled;
  const isEditMode = mode === 'edit';
  const label = isChecked ? REGISTERED_LABEL : NOT_REGISTERED_LABEL;
  const handleSwitchChange = (0, _react.useCallback)(event => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    updatedPolicy.windows.antivirus_registration.enabled = event.target.checked;
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [onChange, policy]);
  if (!isProtectionsAllowed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: CARD_TITLE,
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS],
    dataTestSubj: getTestId(),
    osRestriction: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.av.windowsServerNotSupported', {
      defaultMessage: 'Windows Server operating systems unsupported because Antivirus registration requires Windows Security Center, which is not included in Windows Server operating systems.'
    })
  }, isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: label,
    checked: isChecked,
    onChange: handleSwitchChange,
    "data-test-subj": getTestId('switch')
  }) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('value')
  }, label));
});
exports.AntivirusRegistrationCard = AntivirusRegistrationCard;
AntivirusRegistrationCard.displayName = 'AntivirusRegistrationCard';