"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyEditExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _endpoint_policy_artifact_cards = require("./components/endpoint_policy_artifact_cards");
var _policy_settings_form = require("../../policy_settings_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Exports Endpoint-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const EndpointPolicyEditExtension = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  newPolicy: _newPolicy
}) => {
  const policyUpdates = _newPolicy;
  const endpointPolicySettings = policyUpdates.inputs[0].config.policy.value;
  const {
    canAccessFleet
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const endpointPolicySettingsOnChangeHandler = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    const newPolicyInputs = (0, _lodash.cloneDeep)(policyUpdates.inputs);
    newPolicyInputs[0].config.policy.value = updatedPolicy;
    onChange({
      isValid,
      updatedPolicy: {
        inputs: newPolicyInputs
      }
    });
  }, [onChange, policyUpdates.inputs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "endpointIntegrationPolicyForm"
  }, /*#__PURE__*/_react.default.createElement(_endpoint_policy_artifact_cards.EndpointPolicyArtifactCards, {
    policyId: policy.id
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.settings.title",
    defaultMessage: "Policy settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_policy_settings_form.PolicySettingsForm, {
    policy: endpointPolicySettings,
    onChange: endpointPolicySettingsOnChangeHandler,
    mode: canAccessFleet ? 'edit' : 'view',
    "data-test-subj": "endpointPolicyForm"
  }))));
});
exports.EndpointPolicyEditExtension = EndpointPolicyEditExtension;
EndpointPolicyEditExtension.displayName = 'EndpointPolicyEditExtension';