"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetIntegrationArtifactsCard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../../common/lib/kibana");
var _exception_items_summary = require("../../components/exception_items_summary");
var _link_with_icon = require("../../components/link_with_icon");
var _styled_components = require("../../endpoint_package_custom_extension/components/styled_components");
var _artifacts = require("../../../../../../hooks/artifacts");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARTIFACTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.artifactsSummary.error', {
    defaultMessage: 'There was an error trying to fetch artifacts stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.title",
    defaultMessage: "Artifacts"
  }),
  linkLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.artifactsManageLabel",
    defaultMessage: "Manage artifacts"
  })
};
const FleetIntegrationArtifactsCard = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  artifactApiClientInstance,
  getArtifactsPath,
  searchableFields,
  labels = ARTIFACTS_LABELS,
  privileges = true,
  'data-test-subj': dataTestSubj
}) => {
  const toasts = (0, _kibana.useToasts)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const policyArtifactsPath = getArtifactsPath(policyId);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    data
  } = (0, _artifacts.useSummaryArtifact)(artifactApiClientInstance, {
    policies: [policyId, 'all']
  }, searchableFields, {
    onError: error => {
      toasts.addDanger(labels.artifactsSummaryApiError(error.message));
    }
  });
  const policyArtifactsRouteState = (0, _react.useMemo)(() => {
    const fleetPackageIntegrationCustomUrlPath = `#${_public.pagePathGetters.integration_policy_edit({
      packagePolicyId: policyId
    })[1]}`;
    return {
      backLink: {
        label: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.artifacts.backButtonLabel', {
          defaultMessage: `Back to Fleet integration policy`
        }),
        navigateTo: [_common.INTEGRATIONS_PLUGIN_ID, {
          path: fleetPackageIntegrationCustomUrlPath
        }],
        href: getAppUrl({
          appId: _common.INTEGRATIONS_PLUGIN_ID,
          path: fleetPackageIntegrationCustomUrlPath
        })
      }
    };
  }, [getAppUrl, policyId]);
  const linkToArtifacts = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_link_with_icon.LinkWithIcon, {
    href: getAppUrl({
      path: policyArtifactsPath
    }),
    appPath: policyArtifactsPath,
    appState: policyArtifactsRouteState,
    "data-test-subj": getTestId('link-to-exceptions'),
    size: "m"
  }, labels.linkLabel), [getAppUrl, getTestId, labels.linkLabel, policyArtifactsPath, policyArtifactsRouteState]);

  // do not render if doesn't have privileges.
  // render if doesn't have privileges but has data to show
  if (data === undefined && !privileges || (data === null || data === void 0 ? void 0 : data.total) === 0 && !privileges) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    hasBorder: true,
    "data-test-subj": getTestId('fleet-integration-card')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "flexStart",
    gutterSize: "s",
    direction: "row",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, labels.cardTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_exception_items_summary.ExceptionItemsSummary, {
    stats: data,
    isSmall: true
  })), /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexItem, {
    grow: 1
  }, linkToArtifacts)));
});
exports.FleetIntegrationArtifactsCard = FleetIntegrationArtifactsCard;
FleetIntegrationArtifactsCard.displayName = 'FleetIntegrationArtifactsCard';