"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetArtifactsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/fleet-plugin/public");
var _common = require("@kbn/fleet-plugin/common");
var _kibana = require("../../../../../../../common/lib/kibana");
var _hooks = require("../../../../../../../common/lib/kibana/hooks");
var _link_with_icon = require("../../components/link_with_icon");
var _exception_items_summary = require("../../components/exception_items_summary");
var _styled_components = require("./styled_components");
var _artifacts = require("../../../../../../hooks/artifacts");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARTIFACTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.artifactsSummaryError', {
    defaultMessage: 'There was an error trying to fetch artifacts stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetCustomExtension.title",
    defaultMessage: "Artifacts"
  })
};
const FleetArtifactsCard = /*#__PURE__*/(0, _react.memo)(({
  pkgkey,
  artifactApiClientInstance,
  getArtifactsPath,
  labels = ARTIFACTS_LABELS,
  'data-test-subj': dataTestSubj
}) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const toasts = (0, _kibana.useToasts)();
  const artifactsListUrlPath = getArtifactsPath();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    data
  } = (0, _artifacts.useSummaryArtifact)(artifactApiClientInstance, {}, [], {
    onError: error => toasts.addDanger(labels.artifactsSummaryApiError(error.message))
  });
  const artifactsRouteState = (0, _react.useMemo)(() => {
    const fleetPackageCustomUrlPath = `#${_public.pagePathGetters.integration_details_custom({
      pkgkey
    })[1]}`;
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.backButtonLabel', {
        defaultMessage: 'Return to Elastic Defend integration'
      }),
      onBackButtonNavigateTo: [_common.INTEGRATIONS_PLUGIN_ID, {
        path: fleetPackageCustomUrlPath
      }],
      backButtonUrl: getAppUrl({
        appId: _common.INTEGRATIONS_PLUGIN_ID,
        path: fleetPackageCustomUrlPath
      })
    };
  }, [getAppUrl, pkgkey]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    hasBorder: true,
    "data-test-subj": getTestId('fleetCard')
  }, /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridGroup, {
    alignItems: "baseline",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridItem, {
    gridarea: "title",
    alignitems: "flex-start"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, labels.cardTitle))), /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridItem, {
    gridarea: "summary"
  }, /*#__PURE__*/_react.default.createElement(_exception_items_summary.ExceptionItemsSummary, {
    stats: data
  })), /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridItem, {
    gridarea: "link",
    alignitems: "flex-end"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_link_with_icon.LinkWithIcon, {
    href: getAppUrl({
      path: artifactsListUrlPath
    }),
    appPath: artifactsListUrlPath,
    appState: artifactsRouteState,
    "data-test-subj": getTestId('artifactsLink')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetCustomExtension.manageArtifactsLinkLabel",
    defaultMessage: "Manage"
  }))))));
});
exports.FleetArtifactsCard = FleetArtifactsCard;
FleetArtifactsCard.displayName = 'FleetArtifactsCard';