"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_ARTIFACT_EMPTY_UNEXISTING_LABELS = exports.POLICY_ARTIFACT_EMPTY_UNASSIGNED_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ARTIFACT_EMPTY_UNASSIGNED_LABELS = Object.freeze({
  emptyUnassignedTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unassigned.title', {
    defaultMessage: 'No assigned artifacts'
  }),
  emptyUnassignedMessage: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unassigned.content', {
    defaultMessage: 'There are currently no artifacts assigned to {policyName}. Assign artifacts now or add and manage them on the artifacts page.',
    values: {
      policyName
    }
  }),
  emptyUnassignedPrimaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unassigned.primaryAction', {
    defaultMessage: 'Assign artifacts'
  }),
  emptyUnassignedSecondaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unassigned.secondaryAction', {
    defaultMessage: 'Manage artifacts'
  }),
  emptyUnassignedNoPrivilegesMessage: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unassigned.noPrivileges.content', {
    defaultMessage: 'There are currently no artifacts assigned to {policyName}.',
    values: {
      policyName
    }
  })
});
exports.POLICY_ARTIFACT_EMPTY_UNASSIGNED_LABELS = POLICY_ARTIFACT_EMPTY_UNASSIGNED_LABELS;
const POLICY_ARTIFACT_EMPTY_UNEXISTING_LABELS = Object.freeze({
  emptyUnexistingTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unexisting.title', {
    defaultMessage: 'No artifacts exist'
  }),
  emptyUnexistingMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unexisting.content', {
    defaultMessage: 'There are currently no artifacts applied to your endpoints.'
  }),
  emptyUnexistingPrimaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unexisting.action', {
    defaultMessage: 'Add artifacts'
  })
});
exports.POLICY_ARTIFACT_EMPTY_UNEXISTING_LABELS = POLICY_ARTIFACT_EMPTY_UNEXISTING_LABELS;