"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsAssignableList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _artifact_entry_card = require("../../../../../components/artifact_entry_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyArtifactsAssignableList = /*#__PURE__*/_react.default.memo(({
  artifacts,
  isListLoading,
  selectedArtifactIds,
  selectedArtifactsUpdated
}) => {
  const selectedArtifactIdsByKey = (0, _react.useMemo)(() => selectedArtifactIds.reduce((acc, current) => ({
    ...acc,
    [current]: true
  }), {}), [selectedArtifactIds]);
  const assignableList = (0, _react.useMemo)(() => {
    if (!artifacts || !artifacts.data.length) return null;
    const items = artifacts.data;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "artifactsList"
    }, items.map(artifact => /*#__PURE__*/_react.default.createElement(_artifact_entry_card.ArtifactEntryCardMinified, {
      key: artifact.id,
      item: artifact,
      isSelected: selectedArtifactIdsByKey[artifact.id] || false,
      onToggleSelectedArtifact: selected => selectedArtifactsUpdated(artifact.id, selected)
    })));
  }, [artifacts, selectedArtifactIdsByKey, selectedArtifactsUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isListLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    "data-test-subj": "artifactsAssignableListLoader"
  }), /*#__PURE__*/_react.default.createElement("div", null, assignableList));
});
exports.PolicyArtifactsAssignableList = PolicyArtifactsAssignableList;
PolicyArtifactsAssignableList.displayName = 'PolicyArtifactsAssignableList';