"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPolicyOutOfDate = exports.getIsInvalidDateRange = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isPolicyOutOfDate = (reported, current) => {
  if (!current || !reported.id) {
    return false; // we don't know, can't declare it out-of-date
  }

  return !(reported.id === current.endpoint.id &&
  // endpoint package policy not reassigned
  current.agent.configured.id === current.agent.applied.id &&
  // agent policy wasn't reassigned and not-yet-applied
  // all revisions match up
  reported.version >= current.agent.applied.revision && reported.version >= current.agent.configured.revision && reported.endpoint_policy_version >= current.endpoint.revision);
};
exports.isPolicyOutOfDate = isPolicyOutOfDate;
const getIsInvalidDateRange = ({
  startDate,
  endDate
}) => {
  const start = (0, _moment.default)(_datemath.default.parse(startDate));
  const end = (0, _moment.default)(_datemath.default.parse(endDate));
  if (start.isValid() && end.isValid()) {
    return start.isAfter(end);
  }
  return false;
};
exports.getIsInvalidDateRange = getIsInvalidDateRange;