"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Blocklist = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _services = require("../services");
var _blocklist_form = require("./components/blocklist_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BLOCKLIST_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.pageTitle', {
    defaultMessage: 'Blocklist'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.blocklist.pageAboutInfo', {
    defaultMessage: 'The blocklist prevents selected applications from running on your hosts by extending the list of processes the Endpoint considers malicious.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.pageAddButtonTitle', {
    defaultMessage: 'Add blocklist entry'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.blocklist.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {blocklist entry} other {blocklist entries}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.cardActionEditLabel', {
    defaultMessage: 'Edit blocklist'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.cardActionDeleteLabel', {
    defaultMessage: 'Delete blocklist'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutCreateTitle', {
    defaultMessage: 'Add blocklist'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutEditTitle', {
    defaultMessage: 'Edit blocklist'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add blocklist'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your blocklist.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.blocklist.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.blocklist}`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.blocklist.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "blocklist documentation."
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.blocklist.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from blocklist.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no blocklist entries to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStateTitle', {
    defaultMessage: 'Add your first blocklist entry'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStateInfo', {
    defaultMessage: 'The blocklist prevents specified applications from running on your hosts, extending the list of processes that Endpoint Security considers malicious.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add blocklist entry'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.blocklist.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const Blocklist = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteBlocklist
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const blocklistsApiClient = _services.BlocklistsApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: blocklistsApiClient,
    ArtifactFormComponent: _blocklist_form.BlockListForm,
    labels: BLOCKLIST_PAGE_LABELS,
    "data-test-subj": "blocklistPage",
    flyoutSize: "l",
    allowCardCreateAction: canWriteBlocklist,
    allowCardEditAction: canWriteBlocklist,
    allowCardDeleteAction: canWriteBlocklist
  });
});
exports.Blocklist = Blocklist;
Blocklist.displayName = 'Blocklist';