"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAgentByAgentPolicySummary = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchAgentByAgentPolicySummary = (agentPolicyId, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-policy-agent-summary', agentPolicyId],
    ...options,
    queryFn: async () => {
      return (await http.get(_common.agentRouteService.getStatusPath(), {
        query: {
          policyId: agentPolicyId
        },
        version: _common.API_VERSIONS.public.v1
      })).results;
    }
  });
};
exports.useFetchAgentByAgentPolicySummary = useFetchAgentByAgentPolicySummary;