"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDateRangePicker = exports.useActionsLogFilter = exports.getUiCommand = exports.getCommandKey = exports.getActionStatus = exports.DEFAULT_DATE_RANGE_OPTIONS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _experimental_features_service = require("../../../../common/experimental_features_service");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _translations = require("../translations");
var _response_action_status_badge = require("./response_action_status_badge");
var _use_action_history_url_params = require("./use_action_history_url_params");
var _use_get_endpoints_list = require("../../../hooks/endpoint/use_get_endpoints_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_RANGE_OPTIONS = Object.freeze({
  autoRefreshOptions: {
    enabled: false,
    duration: 10000
  },
  startDate: 'now-24h/h',
  endDate: 'now',
  recentlyUsedDateRanges: []
});
exports.DEFAULT_DATE_RANGE_OPTIONS = DEFAULT_DATE_RANGE_OPTIONS;
const useDateRangePicker = isFlyout => {
  const {
    setUrlDateRangeFilters,
    startDate: startDateFromUrl,
    endDate: endDateFromUrl
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const [dateRangePickerState, setDateRangePickerState] = (0, _react.useState)({
    ...DEFAULT_DATE_RANGE_OPTIONS,
    startDate: isFlyout ? DEFAULT_DATE_RANGE_OPTIONS.startDate : startDateFromUrl !== null && startDateFromUrl !== void 0 ? startDateFromUrl : DEFAULT_DATE_RANGE_OPTIONS.startDate,
    endDate: isFlyout ? DEFAULT_DATE_RANGE_OPTIONS.endDate : endDateFromUrl !== null && endDateFromUrl !== void 0 ? endDateFromUrl : DEFAULT_DATE_RANGE_OPTIONS.endDate
  });
  const updateActionListDateRanges = (0, _react.useCallback)(({
    start,
    end
  }) => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      startDate: start,
      endDate: end
    }));
  }, [setDateRangePickerState]);
  const updateActionListRecentlyUsedDateRanges = (0, _react.useCallback)(recentlyUsedDateRanges => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      recentlyUsedDateRanges
    }));
  }, [setDateRangePickerState]);

  // handle refresh timer update
  const onRefreshChange = (0, _react.useCallback)(evt => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      autoRefreshOptions: {
        enabled: !evt.isPaused,
        duration: evt.refreshInterval
      }
    }));
  }, [setDateRangePickerState]);

  // handle manual time change on date picker
  const onTimeChange = (0, _react.useCallback)(({
    start: newStart,
    end: newEnd
  }) => {
    // update date ranges
    updateActionListDateRanges({
      start: newStart,
      end: newEnd
    });

    // update recently used date ranges
    const newRecentlyUsedDateRanges = [{
      start: newStart,
      end: newEnd
    }, ...dateRangePickerState.recentlyUsedDateRanges.filter(recentlyUsedRange => !(recentlyUsedRange.start === newStart && recentlyUsedRange.end === newEnd)).slice(0, 9)];
    updateActionListRecentlyUsedDateRanges(newRecentlyUsedDateRanges);

    // update URL params for date filters
    if (!isFlyout) {
      setUrlDateRangeFilters({
        startDate: newStart,
        endDate: newEnd
      });
    }
  }, [dateRangePickerState.recentlyUsedDateRanges, isFlyout, setUrlDateRangeFilters, updateActionListDateRanges, updateActionListRecentlyUsedDateRanges]);
  return {
    dateRangePickerState,
    onRefreshChange,
    onTimeChange
  };
};
exports.useDateRangePicker = useDateRangePicker;
const getActionStatus = status => {
  if (status === 'failed') {
    return _translations.UX_MESSAGES.badge.failed;
  } else if (status === 'successful') {
    return _translations.UX_MESSAGES.badge.successful;
  } else if (status === 'pending') {
    return _translations.UX_MESSAGES.badge.pending;
  }
  return '';
};

/**
 * map actual command to ui command
 * unisolate -> release
 * running-processes -> processes
 */
exports.getActionStatus = getActionStatus;
const getUiCommand = command => {
  if (command === 'unisolate') {
    return 'release';
  } else if (command === 'running-processes') {
    return 'processes';
  } else {
    return command;
  }
};

/**
 * map UI command back to actual command
 * release -> unisolate
 * processes -> running-processes
 */
exports.getUiCommand = getUiCommand;
const getCommandKey = uiCommand => {
  if (uiCommand === 'release') {
    return 'unisolate';
  } else if (uiCommand === 'processes') {
    return 'running-processes';
  } else {
    return uiCommand;
  }
};
exports.getCommandKey = getCommandKey;
const useActionsLogFilter = ({
  filterName,
  isFlyout,
  isPopoverOpen,
  searchString
}) => {
  const {
    commands,
    statuses,
    hosts: selectedAgentIdsFromUrl,
    types = [],
    setUrlActionsFilters,
    setUrlHostsFilters,
    setUrlStatusesFilters,
    setUrlTypeFilters
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const isStatusesFilter = filterName === 'statuses';
  const isHostsFilter = filterName === 'hosts';
  const isTypeFilter = filterName === 'type';
  const {
    data: endpointsList,
    isFetching
  } = (0, _use_get_endpoints_list.useGetEndpointsList)({
    searchString,
    selectedAgentIds: selectedAgentIdsFromUrl
  });

  // track the state of selected hosts via URL
  //  when the page is loaded via selected hosts on URL
  const [areHostsSelectedOnMount, setAreHostsSelectedOnMount] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (selectedAgentIdsFromUrl && selectedAgentIdsFromUrl.length > 0) {
      setAreHostsSelectedOnMount(true);
    }
    // don't sync with changes to further selectedAgentIdsFromUrl
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // filter options
  const [items, setItems] = (0, _react.useState)(isTypeFilter ? _constants.RESPONSE_ACTION_TYPE.map(type => ({
    key: type,
    label: getTypeDisplayName(type),
    checked: !isFlyout && types !== null && types !== void 0 && types.includes(type) ? 'on' : undefined,
    'data-test-subj': `${filterName}-filter-option`
  })) : isStatusesFilter ? _constants.RESPONSE_ACTION_STATUS.map(statusName => ({
    key: statusName,
    label: /*#__PURE__*/_react.default.createElement(_response_action_status_badge.ResponseActionStatusBadge, {
      color: statusName === 'successful' ? 'success' : statusName === 'failed' ? 'danger' : 'warning',
      status: getActionStatus(statusName)
    }),
    checked: !isFlyout && statuses !== null && statuses !== void 0 && statuses.includes(statusName) ? 'on' : undefined,
    'data-test-subj': `${filterName}-filter-option`
  })) : isHostsFilter ? [] : _constants.RESPONSE_ACTION_API_COMMANDS_NAMES.filter(commandName => {
    const featureFlags = _experimental_features_service.ExperimentalFeaturesService.get();

    // upload - v8.9
    if (commandName === 'upload' && !featureFlags.responseActionUploadEnabled) {
      return false;
    }
    return true;
  }).map(commandName => ({
    key: commandName,
    label: getUiCommand(commandName),
    checked: !isFlyout && commands !== null && commands !== void 0 && commands.map(command => getCommandKey(command)).includes(commandName) ? 'on' : undefined,
    'data-test-subj': `${filterName}-filter-option`
  })));
  (0, _react.useEffect)(() => {
    if (isHostsFilter && endpointsList) {
      setItems(endpointsList === null || endpointsList === void 0 ? void 0 : endpointsList.map(list => ({
        key: list.id,
        label: list.name,
        checked: !isFlyout && list.selected ? 'on' : undefined,
        'data-test-subj': `${filterName}-filter-option`
      })));
    }
  }, [endpointsList, filterName, isFlyout, isHostsFilter, setItems]);
  const hasActiveFilters = (0, _react.useMemo)(() => !!items.find(item => item.checked === 'on'), [items]);
  const numActiveFilters = (0, _react.useMemo)(() => items.filter(item => item.checked === 'on').length, [items]);
  const numFilters = (0, _react.useMemo)(() => items.filter(item => item.checked !== 'on').length, [items]);
  return {
    areHostsSelectedOnMount,
    isLoading: isHostsFilter && isFetching,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreHostsSelectedOnMount,
    setUrlActionsFilters,
    setUrlHostsFilters,
    setUrlStatusesFilters,
    setUrlTypeFilters
  };
};
exports.useActionsLogFilter = useActionsLogFilter;
const getTypeDisplayName = type => {
  if (type === 'automated') {
    return _translations.FILTER_TYPE_OPTIONS.automated;
  }
  return _translations.FILTER_TYPE_OPTIONS.manual;
};