"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderEndpointInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _use_get_endpoint_details = require("../../../hooks/endpoint/use_get_endpoint_details");
var _endpoint_agent_status = require("../../../../common/components/endpoint/endpoint_agent_status");
var _use_get_endpoint_pending_actions_summary = require("../../../hooks/response_actions/use_get_endpoint_pending_actions_summary");
var _platforms = require("./platforms");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IconContainer = _common.euiStyled.div`
  height: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
`;
const HeaderEndpointInfo = /*#__PURE__*/(0, _react.memo)(({
  endpointId
}) => {
  const {
    data: endpointDetails,
    isFetching
  } = (0, _use_get_endpoint_details.useGetEndpointDetails)(endpointId, {
    refetchInterval: 10000
  });
  const {
    data: endpointPendingActions
  } = (0, _use_get_endpoint_pending_actions_summary.useGetEndpointPendingActionsSummary)([endpointId], {
    refetchInterval: 10000
  });
  if (isFetching && endpointPendingActions === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2
    });
  }
  if (!endpointDetails) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IconContainer, null, /*#__PURE__*/_react.default.createElement(_platforms.PlatformIcon, {
    "data-test-subj": "responderHeaderEndpointPlatformIcon",
    platform: endpointDetails.metadata.host.os.name.toLowerCase()
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: endpointDetails.metadata.host.name,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "responderHeaderEndpointName"
  }, /*#__PURE__*/_react.default.createElement("h6", {
    className: "eui-textTruncate"
  }, endpointDetails.metadata.host.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatus, {
    endpointHostInfo: endpointDetails,
    "data-test-subj": "responderHeaderEndpointAgentIsolationStatus"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "responderHeaderLastSeen"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responder.header.lastSeen",
    defaultMessage: "Last seen {date}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: endpointDetails.last_checkin
      })
    }
  }))))));
});
exports.HeaderEndpointInfo = HeaderEndpointInfo;
HeaderEndpointInfo.displayName = 'HeaderEndpointInfo';