"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecuteCommandArgAboutInfo = exports.ExecuteActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_execute_endpoint_request = require("../../../hooks/response_actions/use_send_execute_endpoint_request");
var _utils = require("../lib/utils");
var _endpoint_execute_action = require("../../endpoint_execute_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExecuteActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3, _command$commandDefin4, _command$args$args2, _command$commandDefin5, _command$commandDefin6;
  const actionCreator = (0, _use_send_execute_endpoint_request.useSendExecuteEndpoint)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2, _command$args$args$ti, _command$args$args, _command$args$args$co;
    const endpointId = (_command$commandDefin = command.commandDefinition) === null || _command$commandDefin === void 0 ? void 0 : (_command$commandDefin2 = _command$commandDefin.meta) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.endpointId;
    if (!endpointId) {
      return;
    }
    return {
      endpoint_ids: [endpointId],
      parameters: {
        command: command.args.args.command[0],
        timeout: (0, _utils.parsedExecuteTimeout)((_command$args$args$ti = command.args.args.timeout) === null || _command$args$args$ti === void 0 ? void 0 : _command$args$args$ti[0])
      },
      comment: (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0]
    };
  }, [(_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : (_command$commandDefin4 = _command$commandDefin3.meta) === null || _command$commandDefin4 === void 0 ? void 0 : _command$commandDefin4.endpointId, command.args.args.command, command.args.args.timeout, (_command$args$args2 = command.args.args) === null || _command$args$args2 === void 0 ? void 0 : _command$args$args2.comment]);
  const {
    result,
    actionDetails: completedActionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'execute'
  });
  if (!completedActionDetails || !completedActionDetails.wasSuccessful) {
    return result;
  }

  // Show results
  return /*#__PURE__*/_react.default.createElement(ResultComponent, {
    "data-test-subj": "executeSuccess",
    showAs: "success",
    title: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.executeAction.successTitle', {
      defaultMessage: 'Command execution was successful.'
    })
  }, /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
    action: completedActionDetails,
    canAccessFileDownloadLink: true,
    agentId: (_command$commandDefin5 = command.commandDefinition) === null || _command$commandDefin5 === void 0 ? void 0 : (_command$commandDefin6 = _command$commandDefin5.meta) === null || _command$commandDefin6 === void 0 ? void 0 : _command$commandDefin6.endpointId,
    textSize: "s",
    "data-test-subj": "console"
  }));
});
exports.ExecuteActionResult = ExecuteActionResult;
ExecuteActionResult.displayName = 'ExecuteActionResult';
const ABOUT_ESCAPE_DASHES = _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.execute.args.command.aboutConsecutiveDashes', {
  defaultMessage: 'Multiple consecutive dashes in the value provided must be escaped. Ex:'
});
const ABOUT_ESCAPE_QUOTES = _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.execute.args.command.aboutQuotes', {
  defaultMessage: 'Quotes provided in the value can be used without escaping. Ex:'
});
const getExecuteCommandArgAboutInfo = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointConsoleCommands.execute.args.command.about",
    defaultMessage: "The command to execute."
  }), /*#__PURE__*/_react.default.createElement("br", null), `${ABOUT_ESCAPE_DASHES} execute --command "/opt/directory\\-\\-\\-directory/myBinary \\-\\-version"`, /*#__PURE__*/_react.default.createElement("br", null), `${ABOUT_ESCAPE_QUOTES} execute --command "cd "C:\\Program Files\\directory""`);
};
exports.getExecuteCommandArgAboutInfo = getExecuteCommandArgAboutInfo;